/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CopyCommand;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;

class MoveCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "MOVE";
    public static final String ARGS = "<sequence-set> <mailbox>";
    public static final String CAPABILITY = "MOVE";

    MoveCommand() {
        super("MOVE", ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        long[] uids;
        MailFolder toFolder;
        IdRange[] idSet = this.parser.parseIdRange(request);
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        ImapSessionFolder currentMailbox = session.getSelected();
        try {
            toFolder = this.getMailbox(mailboxName, session, true);
        }
        catch (FolderException e) {
            e.setResponseCode("TRYCREATE");
            throw e;
        }
        ArrayList<Long> copiedUidsOld = new ArrayList<Long>();
        ArrayList<Long> copiedUidsNew = new ArrayList<Long>();
        for (long uid : uids = currentMailbox.getMessageUids()) {
            boolean inSet;
            if (useUids) {
                inSet = this.includes(idSet, uid);
            } else {
                int msn = currentMailbox.getMsn(uid);
                inSet = this.includes(idSet, msn);
            }
            if (!inSet) continue;
            long copiedUid = currentMailbox.moveMessage(uid, toFolder);
            copiedUidsOld.add(uid);
            copiedUidsNew.add(copiedUid);
        }
        if (useUids) {
            response.okResponse(CopyCommand.generateCopyUidResponseCode(toFolder, copiedUidsOld, copiedUidsNew), "");
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }
}

