/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.pop3.commands.Pop3CommandRegistry;
import com.icegreen.greenmail.server.AbstractSocketProtocolHandler;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.user.UserManager;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.StringTokenizer;

public class Pop3Handler
extends AbstractSocketProtocolHandler {
    Pop3CommandRegistry registry;
    Pop3Connection conn;
    UserManager manager;
    Pop3State state;
    String currentLine;

    public Pop3Handler(Pop3CommandRegistry registry, UserManager manager, Socket socket) {
        super(socket);
        this.registry = registry;
        this.manager = manager;
    }

    @Override
    public void run() {
        try {
            this.conn = new Pop3Connection(this, this.socket);
            this.state = new Pop3State(this.manager);
            this.sendGreetings();
            while (!this.isQuitting()) {
                this.handleCommand();
            }
            this.conn.close();
        }
        catch (SocketTimeoutException ste) {
            this.conn.println("421 Service shutting down and closing transmission channel (socket timeout, SO_TIMEOUT: " + this.getSoTimeout() + "ms)");
            this.conn.quit();
        }
        catch (Exception e) {
            if (!this.isQuitting()) {
                this.log.error("Can not handle POP3 connection", e);
                throw new IllegalStateException("Can not handle POP3 connection", e);
            }
        }
        finally {
            this.close();
        }
    }

    void sendGreetings() {
        this.conn.println("+OK POP3 GreenMail Server v" + BuildInfo.INSTANCE.getProjectVersion() + " ready");
    }

    void handleCommand() throws IOException {
        this.currentLine = this.conn.readLine();
        if (this.currentLine == null) {
            this.close();
            return;
        }
        String commandName = new StringTokenizer(this.currentLine, " ").nextToken().toUpperCase();
        Pop3Command command = this.registry.getCommand(commandName);
        if (command == null) {
            this.conn.println("-ERR Command not recognized");
            return;
        }
        if (!command.isValidForState(this.state)) {
            this.conn.println("-ERR Command not valid for this state");
            return;
        }
        command.execute(this.conn, this.state, this.currentLine);
    }
}

