/*
 * Decompiled with CFR 0.152.
 */
package ipwork;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Record;

public class WhatRealIP {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WhatRealIP(String bd, String log, String domain_n_file) {
        BufferedWriter writer = null;
        try {
            if (!bd.equals("n") && !bd.equals("N")) {
                String l;
                writer = new BufferedWriter(new FileWriter(log, true));
                ArrayList<String> masWebsiteUrl = new ArrayList<String>();
                BufferedReader br = new BufferedReader(new FileReader(bd));
                while ((l = br.readLine()) != null) {
                    masWebsiteUrl.add(l);
                }
                for (String domain : masWebsiteUrl) {
                    writer.write("- - - - - - - - - - - [" + domain + "] - - - - - - - - - -\n");
                    System.out.println("- - - - - - - - - - - [" + domain + "] - - - - - - - - - -");
                    System.out.println("---------------------");
                    this.whatFAW(domain, log);
                    System.out.println("---------------------");
                    this.parseDomainForIP(domain, log);
                    System.out.println("---------------------");
                    this.dnsCheck(domain, log);
                    System.out.println("---------------------");
                    this.parseViewDNS(domain, log);
                    System.out.println("---------------------");
                    this.historyDNS(domain, log);
                    System.out.println("---------------------");
                    System.out.println("- - - - - - - - - - - - - - - - - - - - -");
                    writer.write("- - - - - - - - - - - - - - - - - - - - -\n");
                }
            } else {
                System.out.println("---------------------");
                this.whatFAW(domain_n_file, log);
                System.out.println("---------------------");
                this.parseDomainForIP(domain_n_file, log);
                System.out.println("---------------------");
                this.dnsCheck(domain_n_file, log);
                System.out.println("---------------------");
                this.parseViewDNS(domain_n_file, log);
                System.out.println("---------------------");
                this.historyDNS(domain_n_file, log);
                System.out.println("---------------------");
            }
        }
        catch (Exception e) {
            System.out.println(";( Error  -" + e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDomainForIP(String url, String log) {
        HashSet<String> subdomains = new HashSet<String>();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        }
        catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            Document doc = Jsoup.connect("http://" + url).get();
            Elements links = doc.select("a[href]");
            for (Element link : links) {
                String subdomain;
                String linkHref = link.attr("href");
                if (!linkHref.startsWith("http") || (subdomain = this.getSubdomain(linkHref)) == null) continue;
                subdomains.add(subdomain);
            }
            for (String subdomain : subdomains) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(subdomain);
                    System.out.println("\u041f\u043e\u0434\u0434\u043e\u043c\u0435\u043d: " + subdomain + " -> IP: " + inetAddress.getHostAddress());
                    if (log.equals("n") || log.equals("N")) continue;
                    writer.write("\u041f\u043e\u0434\u0434\u043e\u043c\u0435\u043d: " + subdomain + " -> IP: " + inetAddress.getHostAddress() + "\n");
                }
                catch (UnknownHostException e) {
                    System.out.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 IP \u0434\u043b\u044f \u043f\u043e\u0434\u0434\u043e\u043c\u0435\u043d\u0430: " + subdomain);
                    if (log.equals("n") || log.equals("N")) continue;
                    writer.write("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 IP \u0434\u043b\u044f \u043f\u043e\u0434\u0434\u043e\u043c\u0435\u043d\u0430: " + subdomain + "\n");
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
            }
        }
    }

    private String getSubdomain(String url) {
        try {
            String host = new URL(url).getHost();
            return host;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dnsCheck(String domainName, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        }
        catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(domainName);
            System.out.println("IP-\u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0434\u043e\u043c\u0435\u043d\u0430 " + domainName + ":");
            if (!log.equals("n") && !log.equals("N")) {
                writer.write("IP-\u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0434\u043e\u043c\u0435\u043d\u0430 " + domainName + ":\n");
            }
            for (InetAddress address : addresses) {
                System.out.println(address.getHostAddress());
                if (log.equals("n") || log.equals("N")) continue;
                writer.write(address.getHostAddress() + "\n");
            }
        }
        catch (Exception e) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 IP-\u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u0434\u043e\u043c\u0435\u043d\u0430 " + domainName);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseViewDNS(String domain, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        }
        catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        String url = "http://viewdns.info/iphistory/?domain=" + domain;
        try {
            Document doc = Jsoup.connect(url).get();
            Elements rows = doc.select("table tr");
            for (Element row : rows) {
                Elements columns = row.select("td");
                for (Element column : columns) {
                    System.out.print(column.text() + "\t");
                    if (log.equals("n") || log.equals("N")) continue;
                    writer.write(column.text() + "\t\n");
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 IP-\u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u0434\u043e\u043c\u0435\u043d\u0430 " + domain);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void historyDNS(String domain, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        }
        catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            List<String> nsRecords = this.getNSRecords(domain);
            System.out.println("NS \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u043b\u044f " + domain + ":");
            for (String ns : nsRecords) {
                System.out.println(ns);
            }
            System.out.println("\nIP \u0430\u0434\u0440\u0435\u0441\u0430 NS \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432:");
            if (!log.equals("n") && !log.equals("N")) {
                writer.write("IP \u0430\u0434\u0440\u0435\u0441\u0430 NS \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432:\n");
            }
            for (String ns : nsRecords) {
                List<String> ipAddresses = this.getIPAddresses(ns);
                System.out.println("NS \u0441\u0435\u0440\u0432\u0435\u0440: " + ns);
                if (!log.equals("n") && !log.equals("N")) {
                    writer.write("NS \u0441\u0435\u0440\u0432\u0435\u0440: " + ns + "\n");
                }
                for (String ip : ipAddresses) {
                    System.out.println("IP \u0430\u0434\u0440\u0435\u0441: " + ip);
                    if (log.equals("n") || log.equals("N")) continue;
                    writer.write("IP \u0430\u0434\u0440\u0435\u0441: " + ip + "\n");
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 IP-\u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u0434\u043e\u043c\u0435\u043d\u0430 " + domain);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
            }
        }
    }

    private List<String> getNSRecords(String domain) throws IOException {
        Lookup lookup2 = new Lookup(domain, 2);
        Record[] records = lookup2.run();
        ArrayList<String> nsRecords = new ArrayList<String>();
        if (lookup2.getResult() == 0) {
            for (Record record : records) {
                NSRecord nsRecord = (NSRecord)record;
                nsRecords.add(nsRecord.getTarget().toString());
            }
        } else {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 NS \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + lookup2.getErrorString());
        }
        return nsRecords;
    }

    private List<String> getIPAddresses(String ns) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(ns)) {
                ipAddresses.add(address.getHostAddress());
            }
        }
        catch (Exception e) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 IP \u0434\u043b\u044f " + ns + ": " + e.getMessage());
        }
        return ipAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whatFAW(String websiteUrl, String log) {
        block19: {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(log, true));
            }
            catch (IOException e) {
                System.out.println(";( Error  -" + e);
            }
            try {
                URL url = new URL("http://" + websiteUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                connection.connect();
                Map<String, List<String>> headerFields = connection.getHeaderFields();
                if (!headerFields.containsKey("Server")) break block19;
                List<String> serverHeader = headerFields.get("Server");
                for (String header : serverHeader) {
                    if (!header.toLowerCase().contains("cloudflare") && !header.toLowerCase().contains("ddos-guard")) continue;
                    System.out.println("\u041d\u0430 \u0441\u0430\u0439\u0442\u0435 -> " + websiteUrl + " \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d FAW: " + header);
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write("\u041d\u0430 \u0441\u0430\u0439\u0442\u0435 -> " + websiteUrl + " \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d FAW: " + header + "\n");
                    }
                    return;
                }
            }
            catch (IOException e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043a \u0441\u0430\u0439\u0442\u0443: " + e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430: " + e);
                }
            }
        }
    }
}

