/*
 * Decompiled with CFR 0.152.
 */
package mail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GrabbMail
implements Runnable {
    private Set<String> visitedLinks = new HashSet<String>();
    private static final String EMAIL_REGEX = "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}");
    private ArrayList<String> mas = new ArrayList();
    private String log;
    private String vid;
    private ArrayList<String> massite;

    public GrabbMail() {
    }

    public void gm(String bd, String log, String vid) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(bd));
            while ((line = br.readLine()) != null) {
                this.findEmails(line, log, vid);
            }
        }
        catch (Exception e) {
            System.out.println(";( Error - " + e);
        }
    }

    public GrabbMail(String log, ArrayList<String> massite, String vid) {
        this.log = log;
        this.massite = massite;
        this.vid = vid;
    }

    @Override
    public void run() {
        try {
            for (String line : this.massite) {
                this.findEmails(line, this.log, this.vid);
            }
        }
        catch (Exception e) {
            System.out.println(";( Error - " + e);
        }
    }

    private void findEmails(String url, String log, String vid) {
        if (this.visitedLinks.contains(url)) {
            return;
        }
        this.visitedLinks.add(url);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(log, true));
            Document document = Jsoup.connect("http://" + url).timeout(10000).get();
            this.extractEmails(document, writer, url, vid);
            Elements links = document.select("a[href]");
            for (Element link : links) {
                String nextLink = link.absUrl("href");
                if (!nextLink.startsWith(url) || this.visitedLinks.contains(nextLink)) continue;
                this.findEmails(nextLink, log, vid);
            }
            writer.close();
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043a " + url + ": " + e);
        }
    }

    private void extractEmails(Document document, BufferedWriter writer, String url, String vid) {
        String bodyText = document.body().text();
        Matcher matcher = EMAIL_PATTERN.matcher(bodyText);
        while (matcher.find()) {
            if (vid.equals("1")) {
                System.out.println("\u041d\u0430 - " + url + " \u043d\u0430\u0439\u0434\u0435\u043d email: " + matcher.group());
            } else {
                System.out.println("\u041d\u0430\u0439\u0434\u0435\u043d email: " + matcher.group());
            }
            try {
                if (vid.equals("1")) {
                    writer.write(url + " | " + matcher.group() + "\n");
                    continue;
                }
                writer.write(matcher.group() + "\n");
            }
            catch (Exception e) {
                System.out.println(";( Error - " + e);
            }
        }
        Elements mailtoLinks = document.select("a[href^=mailto:]");
        for (Element mailto : mailtoLinks) {
            String email = mailto.attr("href").replace("mailto:", "").trim();
            if (!this.isValidEmail(email)) continue;
            if (vid.equals("1")) {
                System.out.println("\u041d\u0430 - " + url + " \u043d\u0430\u0439\u0434\u0435\u043d email \u0438\u0437 mailto: " + email);
            } else {
                System.out.println("\u041d\u0430\u0439\u0434\u0435\u043d email \u0438\u0437 mailto: " + email);
            }
            try {
                if (vid.equals("1")) {
                    writer.write(url + " | " + email + "\n");
                    continue;
                }
                writer.write(email + "\n");
            }
            catch (Exception e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

    private boolean isValidEmail(String email) {
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.matches();
    }
}

