/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileListParserImpl;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Util;

public class VMSFTPEntryParser
extends FTPFileListParserImpl {
    private boolean versioning;
    private static final String MONTHS = "(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\d{1,2})-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-([0-9]{4})\\s*((?:[01]\\d)|(?:2[0-3])):([012345]\\d):([012345]\\d)\\s*\\[(([0-9$A-Za-z_]+)|([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+))\\]\\s*\\([a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*\\)";
    private static final Pattern OWNER_SPLIT_PATTERN;

    public VMSFTPEntryParser() {
        this(false);
    }

    public VMSFTPEntryParser(boolean versioning) {
        super(REGEX);
        this.versioning = versioning;
    }

    public FTPFile[] parseFileList(InputStream listStream) throws IOException {
        FTPFile[] files;
        BufferedReader reader = new BufferedReader(new InputStreamReader(listStream));
        String listing = null;
        String line = reader.readLine();
        while (line != null) {
            if (line.trim().equals("") || line.startsWith("Directory") || line.startsWith("Total")) {
                line = reader.readLine();
                continue;
            }
            listing = listing == null ? line : listing + "\r\n" + line;
            line = reader.readLine();
        }
        reader.close();
        byte[] bytes = listing.getBytes();
        ByteArrayInputStream listingStream = new ByteArrayInputStream(bytes);
        if (this.versioning) {
            files = super.parseFileList(listingStream);
        } else {
            FTPFile[] tempFiles = super.parseFileList(listingStream);
            HashMap<String, FTPFile> filesHash = new HashMap<String, FTPFile>();
            for (int index = 0; index < tempFiles.length; ++index) {
                String fileName = tempFiles[index].getName();
                if (filesHash.containsKey(fileName)) continue;
                filesHash.put(fileName, tempFiles[index]);
            }
            files = filesHash.values().toArray(new FTPFile[0]);
        }
        return files;
    }

    public FTPFile parseFTPEntry(String entry) {
        long longBlock = 512L;
        if (this.matches(entry)) {
            String user;
            String grp;
            FTPFile f = new FTPFile();
            f.setRawListing(entry);
            String name = this.group(1);
            String size = this.group(2);
            String day = this.group(3);
            String mo = this.group(4);
            String yr = this.group(5);
            String hr = this.group(6);
            String min = this.group(7);
            String sec = this.group(8);
            String owner = this.group(9);
            ArrayList list = new ArrayList();
            Util.split(list, this._matcher_, OWNER_SPLIT_PATTERN, owner);
            switch (list.size()) {
                case 1: {
                    grp = null;
                    user = (String)list.get(0);
                    break;
                }
                case 2: {
                    grp = (String)list.get(0);
                    user = (String)list.get(1);
                    break;
                }
                default: {
                    grp = null;
                    user = null;
                }
            }
            if (name.lastIndexOf(".DIR") != -1) {
                f.setType(1);
            } else {
                f.setType(0);
            }
            if (this.versioning) {
                f.setName(name);
            } else {
                name = name.substring(0, name.lastIndexOf(";"));
                f.setName(name);
            }
            Long theSize = new Long(size);
            long sizeInBytes = theSize * longBlock;
            f.setSize(sizeInBytes);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(5, new Integer(day));
            cal.set(2, MONTHS.indexOf(mo) / 4);
            cal.set(1, new Integer(yr));
            cal.set(11, new Integer(hr));
            cal.set(12, new Integer(min));
            cal.set(13, new Integer(sec));
            f.setTimestamp(cal);
            f.setGroup(grp);
            f.setUser(user);
            return f;
        }
        return null;
    }

    public String readNextEntry(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer entry = new StringBuffer();
        while (line != null) {
            entry.append(line);
            if (line.trim().endsWith(")")) break;
            line = reader.readLine();
        }
        return entry.length() == 0 ? null : entry.toString();
    }

    static {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            OWNER_SPLIT_PATTERN = compiler.compile(",", 32768);
        }
        catch (MalformedPatternException mpe) {
            throw new IllegalStateException("Pattern compilation failed in VMSFTPEntryParser static initialization block.");
        }
    }
}

