/*
 * Decompiled with CFR 0.152.
 */
package site;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;

public class PortScanner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortScanner(String bd, File log) {
        BufferedReader br = null;
        BufferedWriter writer = null;
        try {
            String l;
            writer = new BufferedWriter(new FileWriter(log, true));
            ArrayList<String> masWebsiteUrl = new ArrayList<String>();
            br = new BufferedReader(new FileReader(bd));
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add(l);
            }
            ArrayList<Integer> mas_num_port = new ArrayList<Integer>();
            mas_num_port.add(20);
            mas_num_port.add(21);
            mas_num_port.add(22);
            mas_num_port.add(23);
            mas_num_port.add(25);
            mas_num_port.add(53);
            mas_num_port.add(80);
            mas_num_port.add(443);
            mas_num_port.add(110);
            mas_num_port.add(143);
            mas_num_port.add(389);
            mas_num_port.add(445);
            mas_num_port.add(587);
            mas_num_port.add(993);
            mas_num_port.add(995);
            mas_num_port.add(1433);
            mas_num_port.add(1521);
            mas_num_port.add(3306);
            mas_num_port.add(3389);
            mas_num_port.add(5432);
            mas_num_port.add(5900);
            mas_num_port.add(8080);
            mas_num_port.add(8443);
            mas_num_port.add(9000);
            mas_num_port.add(9090);
            mas_num_port.add(10000);
            mas_num_port.add(11211);
            mas_num_port.add(27017);
            mas_num_port.add(50000);
            for (String websiteUrl : masWebsiteUrl) {
                if (!log.getName().equalsIgnoreCase("n")) {
                    writer.write("--------------[" + websiteUrl + "]--------------\n");
                }
                System.out.println("--------------[" + websiteUrl + "]--------------");
                Iterator iterator = mas_num_port.iterator();
                while (iterator.hasNext()) {
                    int port = (Integer)iterator.next();
                    if (this.getServiceInfo(websiteUrl, port).equals("")) continue;
                    String serviceInfo = this.getServiceInfo(websiteUrl, port);
                    System.out.println("Port " + port + " is open | " + this.bazaCheck(port) + " | " + serviceInfo);
                    if (log.getName().equalsIgnoreCase("n")) continue;
                    writer.write("Port " + port + " is open | " + this.bazaCheck(port) + " | " + serviceInfo + "\n");
                }
                System.out.println("---------------------------");
                if (log.getName().equalsIgnoreCase("n")) continue;
                writer.write("----------------------------\n");
            }
        }
        catch (Exception e) {
            System.out.println(";( Error - " + e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

    private String getServiceInfo(String host, int port) {
        String string;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), 200);
            string = this.bazaCheck(port);
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return "";
            }
        }
        socket.close();
        return string;
    }

    private String bazaCheck(int port) {
        switch (port) {
            case 20: {
                return "FTP Data Transfer";
            }
            case 21: {
                return "FTP Control";
            }
            case 22: {
                return "SSH";
            }
            case 23: {
                return "Telnet";
            }
            case 25: {
                return "SMTP";
            }
            case 53: {
                return "DNS";
            }
            case 80: {
                return "HTTP";
            }
            case 443: {
                return "HTTPS";
            }
            case 110: {
                return "POP3";
            }
            case 143: {
                return "IMAP";
            }
            case 389: {
                return "LDAP";
            }
            case 445: {
                return "SMB";
            }
            case 587: {
                return "SMTP (Submission)";
            }
            case 993: {
                return "IMAP over SSL";
            }
            case 995: {
                return "POP3 over SSL";
            }
            case 1433: {
                return "Microsoft SQL Server";
            }
            case 1521: {
                return "Oracle Database";
            }
            case 3306: {
                return "MySQL";
            }
            case 3389: {
                return "RDP (Remote Desktop Protocol)";
            }
            case 5432: {
                return "PostgreSQL";
            }
            case 5900: {
                return "VNC";
            }
            case 8080: {
                return "HTTP Alternate";
            }
            case 8443: {
                return "HTTPS Alternate";
            }
            case 9000: {
                return "Tomcat";
            }
            case 9090: {
                return "Tomcat Alternate";
            }
            case 10000: {
                return "Webmin";
            }
            case 11211: {
                return "Memcached";
            }
            case 27017: {
                return "MongoDB";
            }
            case 50000: {
                return "SAP";
            }
        }
        return "Unknown service";
    }
}

