/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FullJavaObfuscator {
    private static final SecureRandom random = new SecureRandom();
    private static final String CHAR_SET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int MIN_NAME_LENGTH = 12;
    private static final int MAX_NAME_LENGTH = 36;
    private static Map<String, String> packageMappings = new HashMap<String, String>();
    private static Map<String, String> classMappings = new HashMap<String, String>();
    private static Map<String, String> methodMappings = new HashMap<String, String>();
    private static Map<String, String> variableMappings = new HashMap<String, String>();
    private static Map<String, String> fileMappings = new HashMap<String, String>();
    private static Path inputDir;
    private static Path outputDir;

    public FullJavaObfuscator(String put_norm, String put_obf) throws IOException {
        inputDir = Paths.get(put_norm, new String[0]).toAbsolutePath();
        outputDir = Paths.get(put_obf, new String[0]).toAbsolutePath();
        if (!Files.exists(inputDir, new LinkOption[0])) {
            System.out.println("Input directory does not exist");
            return;
        }
        FullJavaObfuscator.scanPackagesRecursively(inputDir);
        FullJavaObfuscator.scanJavaFilesRecursively(inputDir);
        FullJavaObfuscator.processFilesRecursively(inputDir, outputDir);
        FullJavaObfuscator.saveMappings(outputDir);
        System.out.println("Obfuscation completed successfully");
    }

    private static void scanPackagesRecursively(Path dir) throws IOException {
        Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(FullJavaObfuscator::containsJavaFiles).forEach(path -> {
            try {
                String packagePath = inputDir.relativize((Path)path).toString().replace(File.separator, ".");
                if (!packagePath.isEmpty() && !packageMappings.containsKey(packagePath)) {
                    String newPackagePath = FullJavaObfuscator.generatePackageName();
                    packageMappings.put(packagePath, newPackagePath);
                    Path newPackageDir = outputDir.resolve(newPackagePath.replace(".", File.separator));
                    Files.createDirectories(newPackageDir, new FileAttribute[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static boolean containsJavaFiles(Path path) {
        try {
            return Files.list(path).anyMatch(p -> p.toString().endsWith(".java"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String generatePackageName() {
        int depth = 1 + random.nextInt(3);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(FullJavaObfuscator.generateRandomName("pkg"));
        }
        return sb.toString();
    }

    private static void scanJavaFilesRecursively(Path dir) throws IOException {
        Files.walk(dir, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".java")).forEach(path -> {
            try {
                String content = new String(Files.readAllBytes(path));
                String packageName = FullJavaObfuscator.extractPackageName(content);
                String className = FullJavaObfuscator.extractClassName(content);
                String newClassName = FullJavaObfuscator.generateRandomName("cls");
                classMappings.put(className, newClassName);
                String fullClassName = packageName.isEmpty() ? className : packageName + "." + className;
                String newFullClassName = packageMappings.getOrDefault(packageName, packageName) + "." + newClassName;
                classMappings.put(fullClassName, newFullClassName);
                String relativePath = inputDir.relativize((Path)path).toString();
                String newRelativePath = FullJavaObfuscator.calculateNewPath(relativePath, packageName, newClassName);
                fileMappings.put(relativePath, newRelativePath);
                FullJavaObfuscator.scanMethodsAndVariables(content);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static String calculateNewPath(String originalPath, String packageName, String newClassName) {
        if (!packageMappings.containsKey(packageName)) {
            return originalPath;
        }
        String newPackagePath = packageMappings.get(packageName).replace(".", File.separator);
        return newPackagePath + File.separator + newClassName + ".java";
    }

    private static void scanMethodsAndVariables(String content) {
        Matcher methodMatcher = Pattern.compile("(?<!@)\\b(?:public|protected|private|static|final|\\s)+[\\w<>\\[\\]]+\\s+(\\w+)\\s*\\([^)]*\\)").matcher(content);
        while (methodMatcher.find()) {
            String methodName = methodMatcher.group(1);
            if (methodMappings.containsKey(methodName) || methodName.startsWith("@")) continue;
            methodMappings.put(methodName, FullJavaObfuscator.generateRandomName("mth"));
        }
        Matcher varMatcher = Pattern.compile("(?<!@)\\b(?:public|protected|private|static|final|\\s)+[\\w<>\\[\\]]+\\s+(\\w+)\\s*(?:=|;|\\))").matcher(content);
        while (varMatcher.find()) {
            String varName = varMatcher.group(1);
            if (variableMappings.containsKey(varName) || varName.startsWith("@")) continue;
            variableMappings.put(varName, FullJavaObfuscator.generateRandomName("var"));
        }
    }

    private static void processFilesRecursively(Path inputDir, Path outputDir) throws IOException {
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        for (Map.Entry<String, String> entry : fileMappings.entrySet()) {
            Path inputFile = inputDir.resolve(entry.getKey());
            Path outputFile = outputDir.resolve(entry.getValue());
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
            String content = new String(Files.readAllBytes(inputFile));
            String obfuscatedContent = FullJavaObfuscator.obfuscateContent(content, inputDir.relativize(inputFile).toString());
            Files.write(outputFile, obfuscatedContent.getBytes(), new OpenOption[0]);
            if (!inputFile.startsWith(outputDir)) continue;
            Files.deleteIfExists(inputFile);
        }
    }

    private static String obfuscateContent(String original, String relativePath) {
        String result = original;
        String packageName = FullJavaObfuscator.extractPackageName(original);
        if (!packageName.isEmpty()) {
            String newPackage = packageMappings.getOrDefault(packageName, packageName);
            result = result.replaceFirst("package\\s+" + packageName.replace(".", "\\.") + "\\s*;", "package " + newPackage + ";");
        }
        Matcher importMatcher = Pattern.compile("import\\s+((?:static\\s+)?([\\w.]+)\\.(\\w+))\\s*;").matcher(result);
        StringBuffer importBuffer = new StringBuffer();
        while (importMatcher.find()) {
            String importClass;
            String fullImport = importMatcher.group(1);
            String importPackage = importMatcher.group(2);
            if (classMappings.containsKey(importPackage + "." + (importClass = importMatcher.group(3)))) {
                String newFullImport = classMappings.get(importPackage + "." + importClass);
                importMatcher.appendReplacement(importBuffer, "import " + newFullImport + ";");
                continue;
            }
            if (classMappings.containsKey(importClass)) {
                String newImportClass = classMappings.getOrDefault(importClass, importClass);
                importMatcher.appendReplacement(importBuffer, "import " + importPackage + "." + newImportClass + ";");
                continue;
            }
            importMatcher.appendReplacement(importBuffer, importMatcher.group(0));
        }
        importMatcher.appendTail(importBuffer);
        result = importBuffer.toString();
        for (Map.Entry<String, String> entry : classMappings.entrySet()) {
            if (!entry.getKey().contains(".")) continue;
            result = result.replaceAll("(?<!//|import |package )\\b" + entry.getKey().replace(".", "\\.") + "\\b", entry.getValue());
        }
        for (Map.Entry<String, String> entry : classMappings.entrySet()) {
            if (entry.getKey().contains(".")) continue;
            result = result.replaceAll("(?<!//|import |package |\\.)\\b" + entry.getKey() + "\\b", entry.getValue().substring(entry.getValue().lastIndexOf(".") + 1));
        }
        for (Map.Entry<String, String> entry : methodMappings.entrySet()) {
            result = result.replaceAll("(?<!@)\\b" + entry.getKey() + "\\(", entry.getValue() + "(");
        }
        for (Map.Entry<String, String> entry : variableMappings.entrySet()) {
            result = result.replaceAll("(?<!@)\\b" + entry.getKey() + "\\b", entry.getValue());
        }
        return result;
    }

    private static String extractPackageName(String content) {
        Matcher matcher = Pattern.compile("package\\s+([\\w.]+)\\s*;").matcher(content);
        return matcher.find() ? matcher.group(1) : "";
    }

    private static String extractClassName(String content) {
        Matcher matcher = Pattern.compile("\\b(?:public|protected|private|static|final|abstract|\\s)*class\\s+(\\w+)").matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("Class name not found in: " + content);
    }

    private static String generateRandomName(String prefix) {
        int length = 12 + random.nextInt(25);
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < length; ++i) {
            sb.append(CHAR_SET.charAt(random.nextInt(CHAR_SET.length())));
        }
        return sb.toString();
    }

    private static void saveMappings(Path outputDir) throws IOException {
        Path mappingsFile = outputDir.resolve("obfuscation_mappings.txt");
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(mappingsFile, new OpenOption[0]));){
            writer.println("=== Package Mappings ===");
            packageMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
            writer.println("\n=== Class Mappings ===");
            classMappings.entrySet().stream().filter(e -> !((String)e.getKey()).contains(".")).sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
            writer.println("\n=== Full Class Name Mappings ===");
            classMappings.entrySet().stream().filter(e -> ((String)e.getKey()).contains(".")).sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
            writer.println("\n=== Method Mappings ===");
            methodMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
            writer.println("\n=== Variable Mappings ===");
            variableMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
            writer.println("\n=== File Mappings ===");
            fileMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> writer.println((String)entry.getKey() + " -> " + (String)entry.getValue()));
        }
    }
}

