/*
 * Decompiled with CFR 0.152.
 */
package workdostup;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import worklog.GrabbZilla;

public class GrabbTegA {
    public GrabbTegA(String host, String port, String username, String password) {
        if (Integer.parseInt(port) == 22) {
            JSch jsch = new JSch();
            Session session = null;
            try {
                session = jsch.getSession(username, host, Integer.parseInt(port));
                session.setPassword(password);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                System.out.println("[+] Successfully connected to the server SSH");
                ChannelSftp channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                GrabbTegA.traverseSSH(channelSftp, "/");
                channelSftp.disconnect();
                session.disconnect();
            }
            catch (Exception e) {
                System.out.println("[-] Error connected to the server SSH");
            }
        } else if (Integer.parseInt(port) == 21) {
            FTPClient ftpClient = new FTPClient();
            try {
                ftpClient.connect(host);
                ftpClient.login(username, password);
                ftpClient.enterLocalPassiveMode();
                ftpClient.setFileType(2);
                System.out.println("[+] Successfully connected to the server FTP");
                GrabbTegA.traverseFTP(ftpClient, "/");
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException e) {
                System.out.println("[-] Error connected to the server FTP");
            }
        } else {
            GrabbZilla gf = new GrabbZilla();
            if (gf.validateFTPConnection(host, Integer.parseInt(port), username, password)) {
                FTPClient ftpClient = new FTPClient();
                try {
                    ftpClient.connect(host);
                    ftpClient.login(username, password);
                    ftpClient.enterLocalPassiveMode();
                    ftpClient.setFileType(2);
                    System.out.println("[+] Successfully connected to the server FTP");
                    GrabbTegA.traverseFTP(ftpClient, "/");
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    System.out.println("[-] Error connected to the server FTP");
                }
            } else if (gf.validateSSHConnection(host, Integer.parseInt(port), username, password)) {
                JSch jsch = new JSch();
                Session session = null;
                try {
                    session = jsch.getSession(username, host, Integer.parseInt(port));
                    session.setPassword(password);
                    session.setConfig("StrictHostKeyChecking", "no");
                    session.connect();
                    System.out.println("[+] Successfully connected to the server SSH");
                    ChannelSftp channelSftp = (ChannelSftp)session.openChannel("sftp");
                    channelSftp.connect();
                    GrabbTegA.traverseSSH(channelSftp, "/");
                    channelSftp.disconnect();
                    session.disconnect();
                }
                catch (Exception e) {
                    System.out.println("[-] Error connected to the server SSH");
                }
            }
        }
    }

    private static void traverseSSH(ChannelSftp channelSftp, String path) {
        try {
            Vector files = channelSftp.ls(path);
            if (files == null) {
                System.out.println("[-] No files found at path: " + path);
                return;
            }
            for (ChannelSftp.LsEntry file : files) {
                if (file == null) continue;
                String filePath = path + "/" + file.getFilename();
                System.out.println("[*] Checking: " + filePath);
                if (file.getAttrs().isDir() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    GrabbTegA.traverseSSH(channelSftp, filePath);
                    continue;
                }
                if (!file.getFilename().endsWith(".html")) continue;
                System.out.println("[+] Found HTML file: " + filePath);
                GrabbTegA.extractLinksFromFileSSH(channelSftp, filePath);
            }
        }
        catch (SftpException e) {
            System.out.println("[-] Error traverse SSH - " + e);
        }
    }

    private static void traverseFTP(FTPClient ftpClient, String path) {
        try {
            FTPFile[] files = ftpClient.listFiles(path);
            if (files == null) {
                System.out.println("[-] No files found at path: " + path);
                return;
            }
            for (FTPFile file : files) {
                if (file == null) continue;
                String filePath = path + "/" + file.getName();
                System.out.println("[*] Checking: " + filePath);
                if (file.isDirectory()) {
                    GrabbTegA.traverseFTP(ftpClient, filePath);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".html")) continue;
                System.out.println("[+] Found HTML file: " + filePath);
                GrabbTegA.extractLinksFromFileFTP(ftpClient, filePath);
            }
        }
        catch (IOException e) {
            System.out.println("[-] Error traverse FTP - " + e);
        }
    }

    private static void extractLinksFromFileFTP(FTPClient ftpClient, String filePath) {
        try (InputStream inputStream = ftpClient.retrieveFileStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                GrabbTegA.findAndPrintLinks(line);
            }
        }
        catch (IOException e) {
            System.out.println("[!-!] Error reading file: " + e.getMessage());
        }
    }

    private static void extractLinksFromFileSSH(ChannelSftp channelSftp, String filePath) {
        try (InputStream inputStream = channelSftp.get(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                GrabbTegA.findAndPrintLinks(line);
            }
        }
        catch (SftpException | IOException e) {
            System.out.println("[!-!] Error reading file: " + e.getMessage());
        }
    }

    private static void findAndPrintLinks(String line) {
        String domainRegex = "\\b(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}\\b";
        Pattern pattern = Pattern.compile(domainRegex);
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            System.out.println("[$_$>] Found domain: " + matcher.group());
        }
    }
}

