package bdwork;

import java.io.*;
import java.util.*;


public class ObedinFile {

    public ObedinFile(String input, String outputFileName) {
        String[] fileNames = input.split(",");

        for (int i = 0; i < fileNames.length; i++) {
            fileNames[i] = fileNames[i].trim();
        }

        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName))) {
            for (String fileName : fileNames) {
                File file = new File(fileName);

                // Проверяем, существует ли файл
                if (!file.exists() || !file.isFile()) {
                    System.out.println("Файл " + fileName + " не найден.");
                    continue;
                }

                try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(line);
                        writer.newLine();
                    }
                } catch (IOException e) {
                    System.out.println("Ошибка при чтении файла " + fileName + ": " + e.getMessage());
                }
            }
        } catch (IOException e) {
            System.out.println("Ошибка при записи в выходной файл: " + e.getMessage());
        }
    }
}
