package ipwork;

import java.io.*;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeletCloneSlova {

    public DeletCloneSlova(String file_sort) {
        Set<String> uniqueLines = new HashSet<>();

        // Чтение строк из файла и добавление их в HashSet для удаления дубликатов
        try (BufferedReader reader = new BufferedReader(new FileReader(file_sort))) {
            String line;
            while ((line = reader.readLine()) != null) {
                uniqueLines.add(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        // Запись уникальных строк обратно в тот же файл
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file_sort))) {
            for (String uniqueLine : uniqueLines) {
                writer.write(uniqueLine);
                writer.newLine();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
