package ipwork;

import java.io.*;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpPortTxt {

    public IpPortTxt(String file_url, String port, String file_bd) {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(file_bd);
            br = new BufferedReader(new FileReader(file_url));
            String url;
            while ((url = br.readLine()) != null) {
                InetAddress ipAddress = InetAddress.getByName(url);
                String ip = ipAddress.getHostAddress();
                if (port.equals("0")) {
                    pw.println(ip);
                    System.out.println(ip);
                } else {
                    pw.println(ip + ":" + port);
                    System.out.println(ip + ":" + port);
                }
            }
        } catch (UnknownHostException e) {} catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            pw.close();
            try {
                br.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}
