package ipwork;

import java.io.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import org.xbill.DNS.*;
import org.xbill.DNS.Record;

import java.util.ArrayList;
import java.util.List;
import java.util.HashSet;
import java.util.Set;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class WhatRealIP {

//-------------------------------------------------------------

    // тут будет 4 способов, что бы узнат ip сайта в обход фаервола
    public WhatRealIP(String bd, String log, String domain_n_file) {
        BufferedWriter writer = null;
        try {
            if (!bd.equals("n") && !bd.equals("N")) {
                writer = new BufferedWriter(new FileWriter(log, true));

                ArrayList<String> masWebsiteUrl = new ArrayList<>();
                BufferedReader br = new BufferedReader(new FileReader(bd));
                String l;
                while ((l = br.readLine()) != null) {
                    masWebsiteUrl.add(l);
                }

                for (String domain : masWebsiteUrl) {
                    writer.write("- - - - - - - - - - - ["+domain+"] - - - - - - - - - -" + "\n");

                    System.out.println("- - - - - - - - - - - ["+domain+"] - - - - - - - - - -" );
                    System.out.println("---------------------");
                    whatFAW(domain, log);
                    System.out.println("---------------------");
                    parseDomainForIP(domain, log);
                    System.out.println("---------------------");
                    dnsCheck(domain, log);
                    System.out.println("---------------------");
                    parseViewDNS(domain, log);
                    System.out.println("---------------------");
                    historyDNS(domain, log);
                    System.out.println("---------------------");
                    System.out.println("- - - - - - - - - - - - - - - - - - - - -");

                    writer.write("- - - - - - - - - - - - - - - - - - - - -" + "\n");
                }
            } else {
                System.out.println("---------------------");
                whatFAW(domain_n_file, log);
                System.out.println("---------------------");
                parseDomainForIP(domain_n_file, log);
                System.out.println("---------------------");
                dnsCheck(domain_n_file, log);
                System.out.println("---------------------");
                parseViewDNS(domain_n_file, log);
                System.out.println("---------------------");
                historyDNS(domain_n_file, log);
                System.out.println("---------------------");
            }
        } catch (Exception e) {
            System.out.println(";( Error  -" + e);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }


//-------------------------------------------------------------

    public void parseDomainForIP(String url, String log) {
        Set<String> subdomains = new HashSet<>();

        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }

        try {
            // Парсим HTML страницы
            Document doc = Jsoup.connect("http://"+url).get();
            Elements links = doc.select("a[href]"); // Находим все ссылки

            for (Element link : links) {
                String linkHref = link.attr("href");
                if (linkHref.startsWith("http")) {
                    String subdomain = getSubdomain(linkHref);
                    if (subdomain != null) {
                        subdomains.add(subdomain);
                    }
                }
            }

            // Выводим IP адреса поддоменов
            for (String subdomain : subdomains) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(subdomain);
                    System.out.println("Поддомен: " + subdomain + " -> IP: " + inetAddress.getHostAddress());
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write("Поддомен: " + subdomain + " -> IP: " + inetAddress.getHostAddress() + "\n");
                    }
                } catch (UnknownHostException e) {
                    System.out.println("Не удалось найти IP для поддомена: " + subdomain);
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write("Не удалось найти IP для поддомена: " + subdomain + "\n");
                    }
                }
            }

        } catch (Exception e) {
            //e.printStackTrace();
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }

    private String getSubdomain(String url) {
        try {
            String host = new java.net.URL(url).getHost();
            return host;
        } catch (Exception e) {
            return null;
        }
    }


//-------------------------------------------------------------

    public void dnsCheck(String domainName, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(domainName);

            System.out.println("IP-адреса для домена " + domainName + ":");
            if (!log.equals("n") && !log.equals("N")) {
                writer.write("IP-адреса для домена " + domainName + ":" + "\n");
            }
            for (InetAddress address : addresses) {
                System.out.println(address.getHostAddress());
                if (!log.equals("n") && !log.equals("N")) {
                    writer.write(address.getHostAddress() + "\n");
                }
            }
        } catch (Exception e) {
            System.err.println("Не удалось найти IP-адрес для домена " + domainName);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }

//-------------------------------------------------------------


    public void parseViewDNS(String domain, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }

        String url = "http://viewdns.info/iphistory/?domain=" + domain;

        try {
            // Парсим HTML страницы
            Document doc = Jsoup.connect(url).get();

            // Извлекаем данные из таблицы
            Elements rows = doc.select("table tr");

            for (Element row : rows) {
                Elements columns = row.select("td");
                for (Element column : columns) {
                    System.out.print(column.text() + "\t");
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write(column.text() + "\t" + "\n");
                    }
                }
                System.out.println();
            }

        } catch (Exception e) {
            System.err.println("Не удалось найти IP-адрес для домена " + domain);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }



//-------------------------------------------------------------


    public void historyDNS(String domain, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            // Получаем NS записи для домена
            List<String> nsRecords = getNSRecords(domain);
            System.out.println("NS записи для " + domain + ":");
            for (String ns : nsRecords) {
                System.out.println(ns);
            }

            // Получаем IP адреса для каждого NS сервера
            System.out.println("\nIP адреса NS серверов:");
            if (!log.equals("n") && !log.equals("N")) {
                writer.write("IP адреса NS серверов:" + "\n");
            }
            for (String ns : nsRecords) {
                List<String> ipAddresses = getIPAddresses(ns);
                System.out.println("NS сервер: " + ns);
                if (!log.equals("n") && !log.equals("N")) {
                    writer.write("NS сервер: " + ns + "\n");
                }
                for (String ip : ipAddresses) {
                    System.out.println("IP адрес: " + ip);
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write("IP адрес: " + ip + "\n");
                    }
                }
            }

        } catch (Exception e) {
            System.err.println("Не удалось найти IP-адрес для домена " + domain);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }

    private List<String> getNSRecords(String domain) throws IOException {
        Lookup lookup = new Lookup(domain, Type.NS);
        Record[] records = lookup.run();
        List<String> nsRecords = new ArrayList<>();

        if (lookup.getResult() == Lookup.SUCCESSFUL) {
            for (Record record : records) {
                NSRecord nsRecord = (NSRecord) record;
                nsRecords.add(nsRecord.getTarget().toString());
            }
        } else {
            System.out.println("Ошибка при получении NS записей: " + lookup.getErrorString());
        }

        return nsRecords;
    }

    private List<String> getIPAddresses(String ns) {
        List<String> ipAddresses = new ArrayList<>();
        try {
            InetAddress[] addresses = InetAddress.getAllByName(ns);
            for (InetAddress address : addresses) {
                ipAddresses.add(address.getHostAddress());
            }
        } catch (Exception e) {
            System.out.println("Ошибка при получении IP для " + ns + ": " + e.getMessage());
        }
        return ipAddresses;
    }


//-------------------------------------------------------------

    public void whatFAW(String websiteUrl, String log) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }
        try {
            URL url = new URL("http://"+websiteUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();

            // Получаем заголовки ответа
            Map<String, List<String>> headerFields = connection.getHeaderFields();

            // Проверяем наличие заголовков, характерных для Cloudflare или DDoS-Guard
            if (headerFields.containsKey("Server")) {
                List<String> serverHeader = headerFields.get("Server");
                for (String header : serverHeader) {
                    if (header.toLowerCase().contains("cloudflare") || header.toLowerCase().contains("ddos-guard")) {
                        System.out.println("На сайте -> " + websiteUrl + " обнаружен FAW: " + header);
                        if (!log.equals("n") && !log.equals("N")) {
                            writer.write("На сайте -> " + websiteUrl + " обнаружен FAW: " + header + "\n");
                        }
                        return;
                    }
                }
            }

        } catch (IOException e) {
            System.err.println("Ошибка при подключении к сайту: " + e);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            } catch (IOException e) {
                System.err.println("Ошибка при закрытии файла: " + e);
            }
        }
    }
//-------------------------------------------------------------

}

