package mail;

import brute.Brutforce;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class GrabbMail implements Runnable {

    //-----------------------------------------------
    public GrabbMail() {}

    private Set<String> visitedLinks = new HashSet<>();
    private static final String EMAIL_REGEX = "[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}";
    private static final Pattern EMAIL_PATTERN = Pattern.compile(EMAIL_REGEX);

    private ArrayList<String> mas = new ArrayList<>();


//-----------------------------------------------


    public void gm(String bd, String log, String vid) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(bd));
            String line;
            while ((line = br.readLine()) != null) {
                findEmails(line, log, vid);
            }
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        }
    }


//-----------------------------------------------

    private String log;
    private String vid;
    private ArrayList<String> massite;
    public GrabbMail(String log, ArrayList<String> massite, String vid) {
        this.log = log;
        this.massite = massite;
        this.vid = vid;
    }


    @Override
    public void run() {
        try {
            for(String line : massite) {
                findEmails(line, log, vid);
            }
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        }
    }

//-----------------------------------------------

    private void findEmails(String url, String log, String vid) {
        if (visitedLinks.contains(url)) {
            return; // Если уже посещали этот URL, выходим
        }

        visitedLinks.add(url); // Добавляем URL в список посещенных

        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(log, true));

            Document document = Jsoup.connect("http://"+url).timeout(10 * 1000).get(); // Увеличиваем таймаут
            extractEmails(document, writer, url, vid);
            Elements links = document.select("a[href]"); // Получаем все ссылки на странице

            for (Element link : links) {
                String nextLink = link.absUrl("href");
                if (nextLink.startsWith(url) && !visitedLinks.contains(nextLink)) { // Проверяем, что ссылка ведет на тот же сайт
                    findEmails(nextLink, log, vid); // Рекурсивно обходим найденные ссылки
                }
            }
            writer.close();
        } catch (IOException e) {
            System.err.println("Ошибка при подключении к " + url + ": " + e);
        }
    }

    private void extractEmails(Document document, BufferedWriter writer, String url, String vid) {
        String bodyText = document.body().text();
        Matcher matcher = EMAIL_PATTERN.matcher(bodyText);
        while (matcher.find()) {
            if (vid.equals("1")) {
                System.out.println("На - " + url + " найден email: " + matcher.group());
            } else {
                System.out.println("Найден email: " + matcher.group());
            }
            try {
                if (vid.equals("1")) {
                    writer.write(url + " | " + matcher.group() + "\n");
                } else {
                    writer.write(matcher.group() + "\n");
                }
            } catch (Exception e) {
                System.out.println(";( Error - " + e);
            }
        }

        // Дополнительная проверка на наличие email в атрибутах
        Elements mailtoLinks = document.select("a[href^=mailto:]");
        for (Element mailto : mailtoLinks) {
            String email = mailto.attr("href").replace("mailto:", "").trim();
            if (isValidEmail(email)) {
                if (vid.equals("1")) {
                    System.out.println("На - " + url + " найден email из mailto: " + email);
                } else {
                    System.out.println("Найден email из mailto: " + email);
                }
                try {
                    if (vid.equals("1")) {
                        writer.write(url + " | " + email + "\n");
                    } else {
                        writer.write(email + "\n");
                    }
                } catch (Exception e) {
                    System.out.println(";( Error - " + e);
                }
            }
        }
    }

    private boolean isValidEmail(String email) {
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.matches();
    }

//-----------------------------------------------
}