package mail;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SmartGrabbMail {

    public void smartgm(String put, String put_log, String vid, int kolvodan, int kolvopotok) throws Exception {

        ArrayList<String> array = new ArrayList<>();
        BufferedReader br = new BufferedReader(new FileReader(put));
        String l;
        while ((l = br.readLine()) != null) {
            array.add(l);
        }

        int n_str = array.size();

        int obshee_kolvo_potok = n_str / kolvodan;
        if (n_str % kolvodan != 0) {
            obshee_kolvo_potok+=1;
        }
        System.out.println("Общее количевство данных: " + n_str);
        System.out.println("Общее количевство потоков: " + obshee_kolvo_potok);

        int kolvo_perebor_potok = 0;
        boolean perebor = false;
        if (obshee_kolvo_potok > kolvopotok) {
            if (obshee_kolvo_potok % kolvopotok != 0) {
                kolvo_perebor_potok = (obshee_kolvo_potok / kolvopotok) + 1;
                perebor = true;
            } else {
                kolvo_perebor_potok = obshee_kolvo_potok / kolvopotok;
            }
        }
        if (perebor) {
            System.out.println("Всего потоков котрое больше стандартных на: " + kolvo_perebor_potok);
            System.out.println("Примерное время работы: " + kolvo_perebor_potok * kolvodan + " часа");
        }
        ExecutorService executor = Executors.newFixedThreadPool(kolvopotok);
        for (int i = 0; i < array.size(); i += kolvopotok * kolvodan) {
            CountDownLatch latch = new CountDownLatch(kolvopotok);

            for (int j = 0; j < kolvopotok; j++) {
                int index = i + j * kolvodan;
                if (index < array.size()) {
                    ArrayList<String> chunk = new ArrayList<>();
                    for (int k = index; k < index + kolvodan && k < array.size(); k++) {
                        chunk.add(array.get(k));
                    }

                    if (!chunk.isEmpty()) {
                        GrabbMail task = new GrabbMail(put_log, chunk, vid);
                        executor.execute(() -> {
                            try {
                                task.run();
                            } finally {
                                latch.countDown();
                            }
                        });
                    } else {
                        latch.countDown();
                    }
                } else {
                    latch.countDown();
                }
            }

            try {
                latch.await();
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        executor.shutdown();
        System.out.println("Программа успешно завершила свою работу!\n" +
                " Путь до лога с результатом работы -> " + put_log);
    }
}
