package mail;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class WorkPentestText {
    public WorkPentestText(String num) {
        String filePath;

        switch (num) {
            case "1":
                filePath = "Тема: Уведомление о серьезной уязвимости на вашем сайте\n" +
                        "\n" +
                        "Уважаемая администрация [Название сайта],\n" +
                        "\n" +
                        "Меня зовут [Ваше имя], я представляю компанию [Название вашей компании], специализирующуюся в области информационной безопасности. В ходе нашего анализа вашего сайта мы обнаружили уязвимость, которая, по нашему мнению, является серьезной и может привести к компрометации вашего сервера и данных пользователей.\n" +
                        "\n" +
                        "Данная уязвимость может быть использована злоумышленниками для несанкционированного доступа к конфиденциальной информации, что может повлечь за собой серьезные последствия как для вашей компании, так и для ваших пользователей.\n" +
                        "\n" +
                        "Мы готовы продемонстрировать найденную уязвимость и предоставить все необходимые детали для ее исправления! Для этого просто ответьте нам на это сообщение. Мы настоятельно рекомендуем вам принять меры для ее устранения как можно скорее.\n" +
                        "\n" +
                        "Пожалуйста, дайте знать, как мы можем продолжить это обсуждение. Мы готовы сотрудничать с вами для обеспечения безопасности вашего сайта и защиты интересов ваших пользователей.\n" +
                        "\n" +
                        "Заранее благодарим за ваше внимание к этому вопросу.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша должность]\n" +
                        "[Название вашей компании]\n" +
                        "[Контактная информация]\n" +
                        "[Сайт вашей компании (если есть)]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Subject: Notification of a serious vulnerability on your site\n" +
                        "\n" +
                        "Dear administration [Site Name],\n" +
                        "\n" +
                        "My name is [Your name], I represent a company [Your company name] specializing in the field of information security. During our analysis of your site, we discovered a vulnerability that, in our opinion, is serious and can lead to compromise of your server and user data.\n" +
                        "\n" +
                        "This vulnerability can be exploited by hackers to gain unauthorized access to confidential information, which can have serious consequences for both your company and your users.\n" +
                        "\n" +
                        "We are ready to demonstrate the vulnerability found and provide all the necessary details to fix it! To do this, just reply to this message. We strongly recommend that you take measures to eliminate it as soon as possible.\n" +
                        "\n" +
                        "Please let us know how we can continue this discussion. We are ready to cooperate with you to ensure the security of your site and protect the interests of your users.\n" +
                        "\n" +
                        "Thank you in advance for your attention to this issue.\n" +
                        "\n" +
                        "With respect,\n" +
                        "\n" +
                        "[your name]\n" +
                        "[Your position]\n" +
                        "[Your company name]\n" +
                        "[Contact Information]\n" +
                        "[Your company's website (if available)]";
                break;
            case "2":
                filePath = "Subject: Security Alert: Outdated Apache Version\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is currently running an outdated version of Apache, which may contain known security vulnerabilities.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Outdated Apache Version\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** Older versions of Apache may have unpatched security vulnerabilities that can be exploited by attackers to gain unauthorized access to your server and sensitive data.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update Apache to the latest stable version.\n" +
                        "- Regularly apply security patches and updates.\n" +
                        "- Consider using a Web Application Firewall (WAF) to protect against known vulnerabilities.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: устаревшая версия Apache\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что на вашем сайте в настоящее время установлена \u200B\u200Bустаревшая версия Apache, которая может содержать известные уязвимости безопасности.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Устаревшая версия Apache\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** В старых версиях Apache могут быть неисправленные уязвимости безопасности, которые могут быть использованы злоумышленниками для получения несанкционированного доступа к вашему серверу и конфиденциальным данным.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите Apache до последней стабильной версии.\n" +
                        "- Регулярно применяйте исправления и обновления безопасности.\n" +
                        "- Рассмотрите возможность использования брандмауэра веб-приложений (WAF) для защиты от известных уязвимостей.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "3":
                filePath = "Subject: Security Alert: CosmoSting Vulnerabilities\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to CosmoSting security issues.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** CosmoSting Vulnerabilities\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** CosmoSting vulnerabilities can be exploited by attackers to gain unauthorized access to your site and sensitive data.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update CosmoSting to the latest stable version.\n" +
                        "- Regularly apply security patches and updates.\n" +
                        "- Consider using a Web Application Firewall (WAF) to protect against known vulnerabilities.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: уязвимости CosmoSting\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для проблем безопасности CosmoSting.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Уязвимости CosmoSting\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** Уязвимости CosmoSting могут быть использованы злоумышленниками для получения несанкционированного доступа к вашему сайту и конфиденциальным данным.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите CosmoSting до последней стабильной версии.\n" +
                        "- Регулярно применяйте исправления и обновления безопасности.\n" +
                        "- Рассмотрите возможность использования брандмауэра веб-приложений (WAF) для защиты от известных уязвимостей.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "4":
                filePath = "Subject: Security Alert: Cross-Site Request Forgery (CSRF) Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to Cross-Site Request Forgery (CSRF) attacks.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Cross-Site Request Forgery (CSRF)\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** CSRF allows attackers to trick users into performing unauthorized actions on your website, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Implement CSRF tokens in your forms and requests.\n" +
                        "- Use the SameSite cookie attribute to restrict the context in which cookies are sent.\n" +
                        "- Regularly review and update your code to ensure it is secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: Уязвимость кросс-сайтовой подделки запросов (CSRF)\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для атак кросс-сайтовой подделки запросов (CSRF).\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Кросс-сайтовая подделка запросов (CSRF)\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** CSRF позволяет злоумышленникам обманом заставить пользователей выполнить несанкционированные действия на вашем сайте, что может привести к утечкам данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Внедрите токены CSRF в свои формы и запросы.\n" +
                        "- Используйте атрибут cookie SameSite, чтобы ограничить контекст, в котором отправляются файлы cookie.\n" +
                        "- Регулярно проверяйте и обновляйте свой код, чтобы убедиться, что он безопасен.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С наилучшими пожеланиями,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "5":
                filePath = "Subject: Security Alert: Log4j Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to the Log4j security issue.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Log4j Vulnerability\n" +
                        "- **Risk:** Critical\n" +
                        "- **Description:** The Log4j vulnerability allows attackers to execute arbitrary code on the server, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update Log4j to the latest version (2.15.0 or later).\n" +
                        "- Apply the necessary patches and updates to all affected systems.\n" +
                        "- Monitor your systems for any suspicious activity.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение о безопасности: уязвимость Log4j\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим к проблеме безопасности Log4j.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Уязвимость Log4j\n" +
                        "- **Риск:** Критический\n" +
                        "- **Описание:** Уязвимость Log4j позволяет злоумышленникам выполнять произвольный код на сервере, что может привести к утечке данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите Log4j до последней версии (2.15.0 или более поздней).\n" +
                        "- Примените необходимые исправления и обновления ко всем затронутым системам.\n" +
                        "- Следите за своими системами на предмет подозрительной активности.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "6":
                filePath = "Subject: Security Alert: Outdated Magento Version\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is currently running an outdated version of Magento, which may contain known security vulnerabilities.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Outdated Magento Version\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** Older versions of Magento may have unpatched security vulnerabilities that can be exploited by attackers to gain unauthorized access to your site and sensitive data.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update Magento to the latest stable version.\n" +
                        "- Regularly apply security patches and updates.\n" +
                        "- Consider using a Web Application Firewall (WAF) to protect against known vulnerabilities.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: устаревшая версия Magento\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что на вашем сайте в настоящее время установлена \u200B\u200Bустаревшая версия Magento, которая может содержать известные уязвимости безопасности.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Устаревшая версия Magento\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** В старых версиях Magento могут быть неисправленные уязвимости безопасности, которые могут быть использованы злоумышленниками для получения несанкционированного доступа к вашему сайту и конфиденциальным данным.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите Magento до последней стабильной версии.\n" +
                        "- Регулярно применяйте исправления и обновления безопасности.\n" +
                        "- Рассмотрите возможность использования брандмауэра веб-приложений (WAF) для защиты от известных уязвимостей.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С наилучшими пожеланиями,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "7":
                filePath = "Subject: Security Alert: Outdated OpenCart Version\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is currently running an outdated version of OpenCart, which may contain known security vulnerabilities.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Outdated OpenCart Version\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** Older versions of OpenCart may have unpatched security vulnerabilities that can be exploited by attackers to gain unauthorized access to your site and sensitive data.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update OpenCart to the latest stable version.\n" +
                        "- Regularly apply security patches and updates.\n" +
                        "- Consider using a Web Application Firewall (WAF) to protect against known vulnerabilities.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: устаревшая версия OpenCart\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что на вашем сайте в настоящее время установлена \u200B\u200Bустаревшая версия OpenCart, которая может содержать известные уязвимости безопасности.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Устаревшая версия OpenCart\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** В старых версиях OpenCart могут быть неисправленные уязвимости безопасности, которые могут быть использованы злоумышленниками для получения несанкционированного доступа к вашему сайту и конфиденциальным данным.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите OpenCart до последней стабильной версии.\n" +
                        "- Регулярно применяйте исправления и обновления безопасности.\n" +
                        "- Рассмотрите возможность использования брандмауэра веб-приложений (WAF) для защиты от известных уязвимостей.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С наилучшими пожеланиями,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "8":
                filePath = "Subject: Security Alert: SQL Injection Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to SQL Injection attacks.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** SQL Injection (SQLI)\n" +
                        "- **Risk:** Critical\n" +
                        "- **Description:** SQL Injection allows attackers to execute arbitrary SQL queries on your database, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Use prepared statements and parameterized queries.\n" +
                        "- Implement input validation and sanitization.\n" +
                        "- Regularly review and update your code to ensure it is secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: уязвимость SQL-инъекции\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для атак SQL-инъекции.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** SQL-инъекция (SQLI)\n" +
                        "- **Риск:** Критический\n" +
                        "- **Описание:** SQL-инъекция позволяет злоумышленникам выполнять произвольные SQL-запросы в вашей базе данных, что может привести к утечкам данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Используйте подготовленные операторы и параметризованные запросы.\n" +
                        "- Реализуйте проверку и очистку входных данных.\n" +
                        "- Регулярно проверяйте и обновляйте свой код, чтобы убедиться, что он безопасен.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "9":
                filePath = "Subject: Security Alert: Server-Side Template Injection (SSTI) Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to Server-Side Template Injection (SSTI) attacks.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Server-Side Template Injection (SSTI)\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** SSTI allows attackers to inject malicious code into server-side templates, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Use secure template engines and libraries.\n" +
                        "- Implement input validation and sanitization.\n" +
                        "- Regularly review and update your code to ensure it is secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: уязвимость внедрения шаблонов на стороне сервера (SSTI)\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для атак внедрения шаблонов на стороне сервера (SSTI).\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Внедрение шаблонов на стороне сервера (SSTI)\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** SSTI позволяет злоумышленникам внедрять вредоносный код в шаблоны на стороне сервера, что может привести к утечкам данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Используйте безопасные шаблонизаторы и библиотеки.\n" +
                        "- Реализуйте проверку и очистку входных данных.\n" +
                        "- Регулярно проверяйте и обновляйте свой код, чтобы убедиться, что он безопасен.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "10":
                filePath = "Subject: Security Alert: Vulnerable WordPress Plugins\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is using vulnerable WordPress plugins.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Vulnerable WordPress Plugins\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** Outdated or vulnerable WordPress plugins can be exploited by attackers to gain unauthorized access to your site and sensitive data.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Update all WordPress plugins to the latest versions.\n" +
                        "- Remove any unused or unnecessary plugins.\n" +
                        "- Regularly review and update your plugins to ensure they are secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: уязвимые плагины WordPress\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт использует уязвимые плагины WordPress.\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Уязвимые плагины WordPress\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** Устаревшие или уязвимые плагины WordPress могут быть использованы злоумышленниками для получения несанкционированного доступа к вашему сайту и конфиденциальным данным.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Обновите все плагины WordPress до последних версий.\n" +
                        "- Удалите все неиспользуемые или ненужные плагины.\n" +
                        "- Регулярно проверяйте и обновляйте свои плагины, чтобы убедиться, что они безопасны.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "11":
                filePath = "Subject: Security Alert: Cross-Site Scripting (XSS) Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to Cross-Site Scripting (XSS) attacks.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** Cross-Site Scripting (XSS)\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** XSS allows attackers to inject malicious scripts into web pages viewed by other users, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Implement input validation and sanitization.\n" +
                        "- Use Content Security Policy (CSP) to restrict the sources of scripts.\n" +
                        "- Regularly review and update your code to ensure it is secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: Уязвимость межсайтового скриптинга (XSS)\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для атак межсайтового скриптинга (XSS).\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** Межсайтовый скриптинг (XSS)\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** XSS позволяет злоумышленникам внедрять вредоносные скрипты в веб-страницы, просматриваемые другими пользователями, что может привести к утечкам данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Внедрите проверку и очистку входных данных.\n" +
                        "- Используйте политику безопасности контента (CSP), чтобы ограничить источники скриптов.\n" +
                        "- Регулярно проверяйте и обновляйте свой код, чтобы убедиться, что он безопасен.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С наилучшими пожеланиями,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            case "12":
                filePath = "Subject: Security Alert: XML External Entity (XXE) Vulnerability\n" +
                        "\n" +
                        "Dear [Admin's Name],\n" +
                        "\n" +
                        "I hope this message finds you well. I am writing to inform you that your website is vulnerable to XML External Entity (XXE) attacks.\n" +
                        "\n" +
                        "**Details:**\n" +
                        "- **Vulnerability:** XML External Entity (XXE)\n" +
                        "- **Risk:** High\n" +
                        "- **Description:** XXE allows attackers to exploit the XML parser to read files on the server, potentially leading to data breaches and unauthorized access.\n" +
                        "\n" +
                        "**Recommendations:**\n" +
                        "- Disable external entity processing in your XML parser.\n" +
                        "- Use secure XML parsers and libraries.\n" +
                        "- Regularly review and update your code to ensure it is secure.\n" +
                        "\n" +
                        "Please take immediate action to address this issue. If you have any questions or need assistance, feel free to contact me.\n" +
                        "\n" +
                        "Best regards,\n" +
                        "\n" +
                        "[Your Name]\n" +
                        "[Your Contact Information]\n" +
                        "\n" +
                        "\n" +
                        "////////////////////////////////////////////////////////\n" +
                        "\n" +
                        "\n" +
                        "Тема: Предупреждение безопасности: уязвимость XML External Entity (XXE)\n" +
                        "\n" +
                        "Уважаемый [Имя администратора],\n" +
                        "\n" +
                        "Надеюсь, это сообщение застанет вас в добром здравии. Я пишу, чтобы сообщить вам, что ваш сайт уязвим для атак XML External Entity (XXE).\n" +
                        "\n" +
                        "**Подробности:**\n" +
                        "- **Уязвимость:** XML External Entity (XXE)\n" +
                        "- **Риск:** Высокий\n" +
                        "- **Описание:** XXE позволяет злоумышленникам использовать XML-анализатор для чтения файлов на сервере, что может привести к утечкам данных и несанкционированному доступу.\n" +
                        "\n" +
                        "**Рекомендации:**\n" +
                        "- Отключите обработку внешних сущностей в вашем XML-анализаторе.\n" +
                        "- Используйте безопасные XML-анализаторы и библиотеки.\n" +
                        "- Регулярно проверяйте и обновляйте свой код, чтобы убедиться, что он безопасен.\n" +
                        "\n" +
                        "Пожалуйста, немедленно примите меры для решения этой проблемы. Если у вас есть какие-либо вопросы или вам нужна помощь, свяжитесь со мной.\n" +
                        "\n" +
                        "С уважением,\n" +
                        "\n" +
                        "[Ваше имя]\n" +
                        "[Ваша контактная информация]";
                break;
            default:
                System.out.println("Invalid input: " + num);
                return; // Завершаем метод, если введен некорректный номер
        }
        System.out.println(filePath);
    }
}

