package site;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import ui.ProxyAdd;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class CheckWebsiteConnection extends ProxyAdd {

    public CheckWebsiteConnection(String file_put1, String new_file_put) {
        try {
            BufferedReader br1 = new BufferedReader(new FileReader(file_put1));


            PrintWriter pw = new PrintWriter(new_file_put);


            ArrayList<String> urls = new ArrayList<>();
            String line;
            while ((line = br1.readLine()) != null) {
                urls.add(line);
            }

            System.out.println("Check http");
            for (String url : urls) {
                try {
                    Document doc = Jsoup.connect("http://" + url)
                            .get();
                    System.out.println(doc.title() + "   ||   " + url);
                    pw.println(url);
                } catch (IOException e) {
                    // Обрабатываем ошибку, если сайт недоступен
                    System.out.println("Ошибка при парсинге сайта: " + e.getMessage());
                }
            }

            pw.close();
        } catch (Exception e) {
            System.out.println("Произошла ошибка при попытке подключения к сайту: " + e.getMessage());
        }
    }


    public CheckWebsiteConnection(String file_put1, String new_file_put, boolean privat_proxy,
                                  String ip, String port, String user, String password) {
        try {
            BufferedReader br1 = new BufferedReader(new FileReader(file_put1));


            PrintWriter pw = new PrintWriter(new_file_put);


            ArrayList<String> urls = new ArrayList<>();
            String line;
            while ((line = br1.readLine()) != null) {
                urls.add(line);
            }

            System.out.println("Check http");
            for (String url : urls) {
                try {
                    Document doc;
                    if (privat_proxy) {
                        doc = privateProxyParse(ip, port, user, password, "http://" + url);
                    } else {
                        doc = publicProxyParse(ip, port, "http://" + url);
                    }
                    System.out.println(doc.title() + "   ||   " + url);
                    pw.println(url);
                } catch (Exception e) {
                    System.out.println("Ошибка при парсинге сайта: " + e.getMessage());
                }
            }

            pw.close();
        } catch (Exception e) {
            System.out.println("Произошла ошибка при попытке подключения к сайту: " + e.getMessage());
        }
    }
}