package ui;


import org.apache.commons.io.FileUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class UsbCrash {


    public UsbCrash() {
        // Проверяем наличие флешки
        boolean isUsbConnected = checkForUsb();

        if (!isUsbConnected) {
            try {
                shutdownComputer();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean checkForUsb() {
        List<File> usbDevices = FileUtils.listFiles(new File("/"), null, true).stream()
                .filter(file -> file.isDirectory())
                .filter(File::canRead)
                .collect(Collectors.toList());

        return !usbDevices.isEmpty(); // Если список не пуст, значит есть хотя бы одно устройство
    }

    private static void shutdownComputer() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();

        if (osName.contains("win")) {
            runtime.exec("shutdown /s /t 0");
        } else {
            runtime.exec("shutdown -h now");
        }
    }

}
