package webhack.csrf;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.util.*;
import java.util.regex.Pattern;

public class TrueCSRF implements Runnable {

    private final Set<String> visitedUrls = new HashSet<>();
    private final Queue<String> urlQueue = new LinkedList<>();
    private final Pattern CSRF_PATTERN = Pattern.compile("(?i)(csrf|token|_token|_csrf|_xsrf)", Pattern.CASE_INSENSITIVE);
    private int stet = 0;


    public void checkCSRF(String startUrl, File log, int maxdomen) {
        int subdomainCount = 0; // Счетчик поддоменов

        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));

            urlQueue.add(startUrl);

            while (!urlQueue.isEmpty()) {
                String url = urlQueue.poll();
                if (visitedUrls.contains(url)) {
                    continue;
                }
                visitedUrls.add(url);

                if (maxdomen != 0 && subdomainCount <= maxdomen) {
                    Document document = Jsoup.connect(url).get();
                    Elements forms = document.select("form");
                    Elements links = document.select("a[href]");

                    for (Element form : forms) {
                        if (!hasCSRFToken(form)) {
                            System.out.println("($_$>) Potential CSRF vulnerability found in form at: " + url + " | and form: " + form);
                            stet++;
                            subdomainCount++;
                            if (!log.equals("n") && !log.equals("N")) {
                                writer.write("($_$>) Potential CSRF vulnerability found in form at: " + url + " | and form: " + form + "\n");
                            }
                        }
                    }

                    for (Element link : links) {
                        String linkUrl = link.absUrl("href");
                        if (linkUrl.startsWith(url) && !visitedUrls.contains(linkUrl)) {
                            urlQueue.add(linkUrl);
                        }
                    }
                }
                else if (maxdomen == 0) { // comit
                    Document document = Jsoup.connect(url).get();
                    Elements forms = document.select("form");
                    Elements links = document.select("a[href]");

                    for (Element form : forms) {
                        if (!hasCSRFToken(form)) {
                            System.out.println("($_$>) Potential CSRF vulnerability found in form at: " + url + " | and form: " + form);
                            stet++;
                            if (!log.equals("n") && !log.equals("N")) {
                                writer.write("($_$>) Potential CSRF vulnerability found in form at: " + url + " | and form: " + form + "\n");
                            }
                        }
                    }

                    for (Element link : links) {
                        String linkUrl = link.absUrl("href");
                        if (linkUrl.startsWith(url) && !visitedUrls.contains(linkUrl)) {
                            urlQueue.add(linkUrl);
                        }
                    }
                } else {
                    break;
                }
            }
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        } finally {
            try {
                if (writer != null) writer.close();
            } catch (IOException e) {
                System.out.println("Error - " + e);
            }
        }
    }

    private boolean hasCSRFToken(Element form) {
        Elements inputs = form.select("input[type=hidden]");
        for (Element input : inputs) {
            if (isCSRFToken(input)) {
                return true;
            }
        }
        return false;
    }

    private boolean isCSRFToken(Element input) {
        String name = input.attr("name");
        String id = input.attr("id");
        String value = input.attr("value");
        String dataAttributes = input.attributes().toString();

        return CSRF_PATTERN.matcher(name).find() ||
                CSRF_PATTERN.matcher(id).find() ||
                CSRF_PATTERN.matcher(value).find() ||
                CSRF_PATTERN.matcher(dataAttributes).find();
    }

//-----------------------------------------------------------------

    public TrueCSRF(String bd, File log, int maxdomen) {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                checkCSRF(websiteUrl, log, maxdomen);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных CSRF: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

//-----------------------------------------------------------------

    public TrueCSRF() {}
    private String bd1;
    private File log1;
    private int maxdomen1;
    public void setBd1(String bd1) {this.bd1 = bd1;}
    public void setLog1(File log1) {this.log1 = log1;}
    public void setMmaxdomen1(int maxdomen1) {this.maxdomen1 = maxdomen1;}


    public void threadRun() {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log1);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd1));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                checkCSRF(websiteUrl, log1, maxdomen1);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных CSRF: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }


    @Override
    public void run() {
        threadRun();
    }



//-----------------------------------------------------------------

}
