package webhack.sql;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class GetSQL extends DopSQL {



    public void testInputFieldsGET(String http_s, String url, File log) {
        if (visitedUrls.contains(http_s+url)) {
            return; // Предотвращаем повторные посещения
        }
        visitedUrls.add(http_s+url);

        try {
            Document doc = Jsoup.connect(http_s+url).timeout(10000).get();

            // Проверка форм
            Elements forms = doc.select("form");
            for (Element form : forms) {
                String action = form.attr("action");
                if (!action.startsWith("http")) {
                    action = http_s+url + action; // Полный URL
                }
                checkGetForm(action, form, http_s+url, log);
            }
        } catch (Exception e) {
            try {
                testInputFieldsGET("https://", url, log);
            } catch (Exception ex) {
                System.out.println("Error - " + ex);
            }
        }
    }

    private void checkGetForm(String action, Element form, String url, File log) {
        StringBuilder response = null;
        try {
            // Получаем все input поля
            Elements inputs = form.select("input");
            for (String payload : testPayloads) {
                StringBuilder testUrl = new StringBuilder(action + "?");
                for (Element input : inputs) {
                    String name = input.attr("name");
                    testUrl.append(name).append("=").append(payload).append("&");
                }
                // Убираем последний '&'
                if (testUrl.length() > 0) {
                    testUrl.setLength(testUrl.length() - 1);
                }

                HttpURLConnection connection = (HttpURLConnection) new URL(String.valueOf(testUrl)).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout((int) TimeUnit.SECONDS.toMillis(5));
                connection.setReadTimeout((int) TimeUnit.SECONDS.toMillis(5));
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                } catch (Exception e) {
                    System.out.println("Connection timed out or failed for URL: " + testUrl);
                }
                String inputLine;
                response = new StringBuilder();

                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                if (isVulnerable(String.valueOf(response))) {
                    System.out.println("($_$>) Potential SQL Injection vulnerability found at: " + url + " | with form: " + form + " | with action: " + action + " | with payload: " + payload);
                    zapisLog(log, "($_$>) Potential SQL Injection vulnerability found at: " + url + " | with form: " + form + " | with action: " + action + " | with payload: " + payload);
                }
            }
        } catch (Exception e) {
            System.out.println("Error - " + e);
        }
    }
}
