package webhack.sql;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class PostSQL extends DopSQL {


    public void testInputFieldsPOST(String http_s, String url, File log) {
        if (visitedUrls.contains(http_s+url)) {
            return; // Предотвращаем повторные посещения
        }
        visitedUrls.add(http_s+url);

        try {
            Document doc = Jsoup.connect(http_s+url).timeout(10000).get(); // Установка тайм-аута на 10 секунд
            Elements forms = doc.select("form");

            for (Element form : forms) {
                // Обработка всех типов полей ввода
                Elements inputFields = form.select("input, textarea, select");
                for (Element input : inputFields) {
                    String fieldName = input.attr("name");
                    if (fieldName.isEmpty()) {
                        fieldName = input.attr("id"); // Используем id, если name отсутствует
                    }
                    if (fieldName.isEmpty()) {
                        fieldName = "unknown"; // Если нет ни name, ни id
                    }
                    testFieldPOST(http_s+url, fieldName, log);
                }
            }
        } catch (Exception e) {
            try {
                testInputFieldsPOST("https://", url, log);
            } catch (Exception ex) {
                System.out.println("Error - " + ex);
            }
        }
    }


    private void testFieldPOST(String url, String field, File log) {

        for (String payload : testPayloads) {
            try {
                String response = sendPostRequest(url, field, payload);
                if (isVulnerable(response)) {
                    System.out.println("($_$>) Potential SQL Injection vulnerability found at: " + url + " | with filed: " + field + " | with payload: " + payload);
                    zapisLog(log, "($_$>) Potential SQL Injection vulnerability found at: " + url + " | with filed: " + field + " | with payload: " + payload);
                    //break;
                }
            } catch (Exception e) {
                System.out.println("Error - " + e);
            }
        }
    }

    private String sendPostRequest(String targetUrl, String field, String payload) throws Exception {
        URL url = new URL(targetUrl);
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");

        // Установка тайм-аутов
        connection.setConnectTimeout(10000); // Тайм-аут подключения 10 секунд
        connection.setReadTimeout(10000); // Тайм-аут чтения 10 секунд

        String postData = field + "=" + payload;

        try (OutputStream os = connection.getOutputStream()) {
            os.write(postData.getBytes());
            os.flush();
        }

        BufferedReader in;
        try {
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        } catch (Exception e) {
            System.out.println("Connection timed out or failed for URL: " + targetUrl);
            return ""; // Возвращаем пустую строку в случае ошибки
        }

        String inputLine;
        StringBuilder response = new StringBuilder();

        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();

        return response.toString();
    }
}
