package webhack.ssti;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.io.OutputStream;

import java.io.*;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class LiteSSTI implements Runnable {

    int stet = 0;
    private Set<String> visitedUrls = new HashSet<>();

    public LiteSSTI(String bd, File log, int maxdomen) {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                crawlWebsite(websiteUrl, log, maxdomen);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных SSTI: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }






//-----------------------------------------------------------------




    public LiteSSTI() {}

    private String bd1;
    private File log1;
    private int maxdomen1;
    public void setBd1(String bd1) {this.bd1 = bd1;}
    public void setLog1(File log1) {this.log1 = log1;}
    public void setMmaxdomen1(int maxdomen1) {this.maxdomen1 = maxdomen1;}

    public void threadRun() {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log1);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd1));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                crawlWebsite(websiteUrl, log1, maxdomen1);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных SSTI: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }
    @Override
    public void run() {
        threadRun();
    }



//-----------------------------------------------------------------



    private void crawlWebsite(String url, File log, int maxd) throws IOException {
        int stet_url = 0;

        String[] payloads = {
                "{{7*7}}",
                "${7*7}",
                "{% raw %}{{7*7}}{% endraw %}",
                "${{7*7}}",
                "#{ 7 * 7 }",
                "#{7*7}",
                "@(7*7)",
                "<%= 7 * 7 %>"
        };

        // Используем стек для хранения URL
        Stack<String> urlStack = new Stack<>();
        urlStack.push(url); // Начинаем с начального URL

        while (!urlStack.isEmpty()) {
            if (stet_url <= maxd && maxd != 0) {

                String currentUrl = urlStack.pop();

                if (visitedUrls.contains(currentUrl)) {
                    continue; // Если URL уже посещен, пропускаем его
                }

                visitedUrls.add(currentUrl); // Добавляем URL в список посещенных
                Document doc = Jsoup.connect(currentUrl).get();


                checkSSTI(doc, currentUrl, payloads, log);

                // Находим все ссылки на текущей странице
                Elements links = doc.select("a[href]");
                for (Element link : links) {
                    String absUrl = link.absUrl("href");
                    if (absUrl.startsWith(url) && !visitedUrls.contains(absUrl)) { // Проверяем, что ссылка ведет на тот же сайт и не посещена
                        urlStack.push(absUrl); // Добавляем URL в стек для дальнейшей обработки
                        stet_url++;
                    }
                }
            }
            else if (maxd == 0) { // comit
                String currentUrl = urlStack.pop();

                if (visitedUrls.contains(currentUrl)) {
                    continue; // Если URL уже посещен, пропускаем его
                }

                visitedUrls.add(currentUrl); // Добавляем URL в список посещенных
                Document doc = Jsoup.connect(currentUrl).get();


                checkSSTI(doc, currentUrl, payloads, log);

                // Находим все ссылки на текущей странице
                Elements links = doc.select("a[href]");
                for (Element link : links) {
                    String absUrl = link.absUrl("href");
                    if (absUrl.startsWith(url) && !visitedUrls.contains(absUrl)) { // Проверяем, что ссылка ведет на тот же сайт и не посещена
                        urlStack.push(absUrl); // Добавляем URL в стек для дальнейшей обработки
                        stet_url++;
                    }
                }
            }
            else {
                break;
            }
        }
    }

    private void checkSSTI(Document doc, String url, String[] payloads, File log_file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log_file, true));

            Elements inputFields = doc.select("input, textarea");

            for (Element input : inputFields) {
                String inputName = input.attr("name");
                if (!inputName.isEmpty()) {
                    for (String payload : payloads) {
                        String response = sendPostRequest(url, inputName, payload);
                        if (response.contains("49")) { // Проверка на результат 7*7
                            System.out.println("($_$>) Potential SSTI vulnerability is url: " + url + " | found with payload: " + payload + " | in field: " + inputName);
                            if (!log_file.equals("n") && !log_file.equals("N")) {
                                writer.write("($_$>) Potential SSTI vulnerability is url: " + url + " | found with payload: " + payload + " | in field: " + inputName + "\n");
                            }
                            stet++;
                        } else {
                            System.out.println(";( No SSTI detected in url: " + url);
                        }
                    }
                }
            }
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        } finally {
            try {
                if (writer != null) writer.close();
            } catch (IOException e) {
                System.out.println("Error - " + e);
            }
        }
    }

    private String sendPostRequest(String targetUrl, String inputName, String payload) {
        StringBuilder response = new StringBuilder();
        try {
            URL url = new URL(targetUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");

            String postData = inputName + "=" + payload; // Используем имя поля ввода

            try (OutputStream os = connection.getOutputStream()) {
                os.write(postData.getBytes());
                os.flush();
            }

            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        } catch (Exception e) {
            System.out.println("Error - " + e);
        }
        return response.toString();
    }
}

