package admin.crupt;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Optional;

public class Crupt {
    public String cryptor(String algorithm, String input, SecretKey key,
                        IvParameterSpec iv) throws Exception {

        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(Cipher.ENCRYPT_MODE, key, iv);
        byte[] cipherText = cipher.doFinal(input.getBytes());
        String base64 = Base64.getEncoder()
                .encodeToString(cipherText);

        String i = Optional.ofNullable(base64)
                .filter(str -> str.length() != 0)
                .map(str -> str.substring(0, str.length() - 1))
                .orElse(base64);

        String rez = Optional.ofNullable(i)
                .filter(str -> str.length() != 0)
                .map(str -> str.substring(0, str.length() - 1))
                .orElse(i);
        return rez;
    }


    public static void encryptFile(String inputFilePath, String outputPath, String KEY) throws Exception {
        new File(outputPath + "file_image.png").createNewFile();
        byte[] keyBytes = KEY.getBytes(StandardCharsets.UTF_8);
        Key key = new SecretKeySpec(keyBytes, "AES");

        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.ENCRYPT_MODE, key);

        byte[] originalFileBytes = readBytesFromFile(inputFilePath);
        byte[] encryptedFileBytes = cipher.doFinal(originalFileBytes);
        writeBytesToFile(outputPath + "file_image.png", encryptedFileBytes);
    }

    private static byte[] readBytesFromFile(String filePath) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filePath);
        byte[] bytes = fileInputStream.readAllBytes();
        fileInputStream.close();
        return bytes;
    }

    private static void writeBytesToFile(String filePath, byte[] bytes) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
        fileOutputStream.write(bytes);
        fileOutputStream.close();
    }
}
