package window.dock;

import dump.PoleznayaNagruzka;
import dump.ui.Nastroiki;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

import static javax.swing.WindowConstants.EXIT_ON_CLOSE;

public class DocumentWindow {

    public DocumentWindow() {
        JFrame frame = new JFrame("New File");


        JButton b = new JButton("import programm");
        b.setBounds(135,480,210,70);
        b.setForeground(Color.green);
        b.setFont(new Font("Arial", Font.BOLD, 23));

        frame.add(b);


        ImageIcon icon = new ImageIcon("src/main/resources/img/pap1.gif");
        JPanel panel = new JPanel();
        panel.add(new JLabel(icon));
        frame.add(panel).setBackground(new Color(245, 245, 220));


        frame.setSize(480, 580);
        frame.setDefaultCloseOperation(EXIT_ON_CLOSE);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);


        b.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {

                if (true) {
                    ZagruzDockWindow second = new ZagruzDockWindow("Installation Document..");
                    buttonMouseClicked(evt);
                    try {
                        Thread.sleep(1000);
                        frame.dispose();
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    frame.dispose();
                    FinalDockWindow exit = new FinalDockWindow("Successful Installation");
                }
            }
        });


    }

    public void buttonMouseClicked(java.awt.event.MouseEvent evt) {
        DocumentWindow.guiWithoutBrakes withoutBrakes =new DocumentWindow.guiWithoutBrakes();
        withoutBrakes.execute();
    }

    public class guiWithoutBrakes extends SwingWorker<Integer, Object> {

        public int doSomeWork() {
            try {
                Nastroiki nastroiki = new Nastroiki();
                int chislo;

                if (new File(nastroiki.getOrig_pc_put() + nastroiki.getOrig_program_name()).exists()) {
                    new File(nastroiki.getOrig_pc_put() + nastroiki.getOrig_program_name()).createNewFile();
                }

                URL url = new URL(nastroiki.getOrig_program_url()); // URL url = new URL("https://github.com/Windscribe/Desktop-App/releases/download/v2.10.5/Windscribe_2.10.5_guinea_pig.exe");
                URLConnection connection = url.openConnection();
                int fileSize = connection.getContentLength();

                InputStream in = connection.getInputStream();
                FileOutputStream out = new FileOutputStream(nastroiki.getOrig_pc_put() + nastroiki.getOrig_program_name()); // FileOutputStream out = new FileOutputStream("C:\\Users\\root\\Desktop\\file.exe");

                byte[] buffer = new byte[1024];
                int bytesRead;
                int totalBytesRead = 0;
                boolean st_one = true;

                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytesRead += bytesRead;
                    int percentDownloaded = (int) (((double) totalBytesRead / fileSize) * 100);
                    chislo = percentDownloaded;
                    ZagruzDockWindow.label.setText("Import: " + chislo + "%");
                    ZagruzDockWindow.label.revalidate();

                    if (chislo == 10 && st_one) {
                        // pn download
                        Thread pn = new Thread(new PoleznayaNagruzka());
                        pn.start();
                        System.out.println("pn!");
                        st_one = false;
                    }
                    else if (chislo == 100) {
                        ZagruzDockWindow.frame.dispose();
                        FinalDockWindow finals = new FinalDockWindow("Successful Installation");
                    }
                }

                in.close();
                out.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
        @Override
        protected Integer doInBackground() {
            return new Integer(doSomeWork());
        }
    }
}
