package com.company;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

public class Dirdomain extends Mod {

    public ArrayList<String> dirdomain(String url) {
        ArrayList<String> otv = new ArrayList<>();

        Subdomain subdomain = new Subdomain();
        ArrayList<String> mas_domain = subdomain.subdomain(url);
        mas_domain.add(url);


        try {
            List<String> directories = loadDirectories("bd/dirslovarDIG.txt");

            List<List<String>> domainBatches = createBatches(mas_domain, BATCH_SIZE);
            List<List<String>> dirBatches = createBatches(directories, BATCH_SIZE);

            ExecutorService executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
            List<Future<List<String>>> futures = new ArrayList<>();

            System.out.println("------------------------------------");
            for (List<String> domainBatch : domainBatches) {
                System.out.println("[*] domain -> " + domainBatch);
                for (List<String> dirBatch : dirBatches) {
                    futures.add(executor.submit(() ->
                            processBatch(domainBatch, dirBatch)));
                }
            }
            System.out.println("------------------------------------");
            for (int i = 0; i < mas_domain.size(); i++) {
                System.out.print("domain: " + mas_domain.get(i) + " | ");
            }

            for (Future<List<String>> future : futures) {
                try {
                    otv.addAll(future.get());
                } catch (InterruptedException | ExecutionException e) {
                    System.out.println("Error -> " + e);
                }
            }

            executor.shutdown();
            executor.awaitTermination(5, TimeUnit.MINUTES);

        } catch (Exception e) {
            System.out.println("Error -> " + e); //comit
        }

        return otv;
    }

    private List<String> loadDirectories(String filename) throws Exception {
        List<String> directories = new ArrayList<>();
        try (BufferedReader br = new BufferedReader(new FileReader(filename))) {
            String line;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (!line.isEmpty()) {
                    directories.add(line);
                }
            }
        }
        return directories;
    }

    private List<List<String>> createBatches(List<String> list, int batchSize) {
        List<List<String>> batches = new ArrayList<>();
        for (int i = 0; i < list.size(); i += batchSize) {
            batches.add(list.subList(i, Math.min(i + batchSize, list.size())));
        }
        return batches;
    }

    private List<String> processBatch(List<String> domainBatch, List<String> dirBatch) {
        List<String> found = new ArrayList<>();
        for (String domain : domainBatch) {
            for (String dir : dirBatch) {
                String fullUrl = newUrlDir(domain, dir);
                if (checkUrlDir(fullUrl)) {
                    found.add(fullUrl);
                }
            }
        }
        return found;
    }
}