package com.company;

import java.io.File;
import java.io.FileWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class Mod {

    public static int THREAD_POOL_SIZE;
    public static int BATCH_SIZE;
    public static void setThreadPoolSize(int threadPoolSize) { THREAD_POOL_SIZE = threadPoolSize; }
    public static void setBatchSize(int batchSize) { BATCH_SIZE = batchSize; }

    public static int code_skip;
    public static String put_file;
    public static void setCode_skip(int code_skip) { Mod.code_skip = code_skip; }
    public static void setPut_file(String put_file) { Mod.put_file = put_file; }

    public boolean checkUrlSub(String url) {
        try {
            long startTime = System.currentTimeMillis();

            HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
            connection.setConnectTimeout(1500);
            connection.setReadTimeout(1000);
            connection.connect();

            int responseCode = connection.getResponseCode();
            long contentLength = connection.getContentLengthLong();
            long endTime = System.currentTimeMillis();
            double elapsedTimeSec = (double)(endTime - startTime)/1000;


            if (responseCode != 400 && responseCode != 404 && responseCode != code_skip) {
                if (responseCode >= 200 && responseCode <= 220) {
                    System.out.println("\u001B[32m"+"["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else if (responseCode >= 300 && responseCode <= 320) {
                    System.out.println("\u001B[33m"+"["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else if (responseCode >= 500 && responseCode <= 520) {
                    System.out.println("\u001B[34m"+"["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else {
                    System.out.println("["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url);
                }
                zapis(put_file, "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url);

                return true;
            }

            //if (responseCode >= 400 && responseCode <= 406) {
             //   return true;
           // }

        } catch (Exception e) {
        }
        return false;
    }


    public boolean checkUrlDir(String url) {
        try {
            long startTime = System.currentTimeMillis();

            HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
            connection.setConnectTimeout(1500);
            connection.setReadTimeout(1000);
            connection.connect();

            int responseCode = connection.getResponseCode();
            long contentLength = connection.getContentLengthLong();
            long endTime = System.currentTimeMillis();
            double elapsedTimeSec = (double)(endTime - startTime)/1000;

            if (responseCode >= 400 && responseCode <= 406 && responseCode != code_skip) {
                if (responseCode >= 200 && responseCode <= 220) {
                    System.out.println("\u001B[32m"+ "    |-----> " + "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else if (responseCode >= 300 && responseCode <= 320) {
                    System.out.println("\u001B[33m"+ "    |-----> " + "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else if (responseCode >= 500 && responseCode <= 520) {
                    System.out.println("\u001B[34m"+ "    |-----> " + "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url+"\u001B[0m");
                } else {
                    System.out.println("    |-----> " + "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url);
                }
                zapis(put_file, "    |-----> " + "["+responseCode+"] lenght: "+contentLength+"; time: "+elapsedTimeSec+"; url: "+url);

                return true;
            }

        } catch (Exception e) {
        }
        return false;
    }

    public String newUrlSub(String url, String sub) {
        String modifiedHost = sub + "." + extractDomain(url);

        return replaceHostInUrl(url, modifiedHost);
    }

    private String extractDomain(String url) {
        try {
            java.net.URL parsedUrl = new java.net.URL(url);
            return parsedUrl.getHost();
        } catch (Exception e) {
            return null;
        }
    }

    private String replaceHostInUrl(String originalUrl, String newHost) {
        try {
            java.net.URL oldUrl = new java.net.URL(originalUrl);

            return new java.net.URL(oldUrl.getProtocol(), newHost, oldUrl.getPort(), oldUrl.getFile()).toString();
        } catch (Exception e) {
            return null;
        }
    }

    private void zapis(String put, String str) {
        try {
            if (!str.equals("n") && !str.equals("N")) {
                if (!new File(put).exists()) {
                    new File(put).createNewFile();
                }
                FileWriter writer = new FileWriter(put, true);
                writer.write(str);
                writer.close();
            }
        } catch (Exception e) {
            System.out.println("Error -> " + e);
        }
    }


    public String newUrlDir(String url, String sub) {
        return url + "/" + sub;
    }

}
