package com.company;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

public class Subdomain extends Mod {

    public ArrayList<String> subdomain(String url) {
        ArrayList<String> otv = new ArrayList<>();

        try {
            List<String> allSubdomains = new ArrayList<>();
            BufferedReader br = new BufferedReader(new FileReader("bd/slovar_subdomains.txt"));
            String sub;
            while ((sub = br.readLine()) != null) {
                allSubdomains.add(sub.trim());
            }
            br.close();

            List<List<String>> batches = createBatches(allSubdomains, BATCH_SIZE);

            ExecutorService executor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
            List<Future<List<String>>> futures = new ArrayList<>();

            for (List<String> batch : batches) {
                Callable<List<String>> task = () -> processBatch(url, batch);
                futures.add(executor.submit(task));
            }

            for (Future<List<String>> future : futures) {
                try {
                    otv.addAll(future.get());
                } catch (InterruptedException | ExecutionException e) {
                    System.out.println("Error -> " + e);
                }
            }

            executor.shutdown();
            executor.awaitTermination(1, TimeUnit.MINUTES);


        } catch (Exception e) {
            System.out.println("Error -> " + e); //comit
        }
        return otv;
    }

    private List<List<String>> createBatches(List<String> list, int batchSize) {
        List<List<String>> batches = new ArrayList<>();
        for (int i = 0; i < list.size(); i += batchSize) {
            batches.add(list.subList(i, Math.min(i + batchSize, list.size())));
        }
        return batches;
    }

    private List<String> processBatch(String url, List<String> batch) {
        List<String> foundSubdomains = new ArrayList<>();
        for (String subdomain : batch) {
            if (checkUrlSub(newUrlSub(url, subdomain))) {
                foundSubdomains.add(subdomain);
            }
        }
        return foundSubdomains;
    }
}
