package com.example.MeteoStarSpring.controllers;

import com.example.MeteoStarSpring.components.CheckRoot;
import com.example.MeteoStarSpring.components.DateTime;
import com.example.MeteoStarSpring.components.MyComponent;
import com.example.MeteoStarSpring.dop.*;
import com.example.MeteoStarSpring.models.Post;
import com.example.MeteoStarSpring.repo.PostRepository;
import com.example.MeteoStarSpring.telegram.StartBot;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ControllerWeb {

    @Autowired
    private PostRepository postRepository;
    @Autowired
    CheckRoot croot;
    @Autowired
    MyComponent myComp;
    @Autowired
    GrafickJson grafick;

    private boolean root = false;

    @GetMapping("/")
    public String autorisation(Model model) {
        model.addAttribute("title", "Вход");
        if (!root) {
            return "autorisation";
        } else {
            return "redirect:/glav";
        }
    }

    @PostMapping("/autoisation")
    public String trueAutorisation(@RequestParam String log, @RequestParam String pass, Model model) {
        if (croot.checkRoot(log, pass)) {
            root = true;
            return "redirect:/glav"; // либо index
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/glav")
    public String startingGlav(Model model, Model model1, Model model2, Model model3) { //
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.Esp32GetJson(myComp.getIpesp(), myComp.getMyToken());
            DateTime dt = new DateTime();

            String data = dt.dt();
            int svet = Integer.parseInt(esp.getSvet());
            double vlashnost = Double.parseDouble(esp.getVlashnost());
            double temp = Double.parseDouble(esp.getTemp());

            Post post = new Post(svet, vlashnost, temp, data);
            postRepository.save(post);

            model.addAttribute("data", data);
            model1.addAttribute("svet", String.valueOf(svet));
            model2.addAttribute("vlashnost", String.valueOf(vlashnost));
            model3.addAttribute("temp", String.valueOf(temp));

            return "index";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/full")
    public String parseDannye(Model model) {
        if (root) {
            Iterable<Post> posts = postRepository.findAll();
            model.addAttribute("posts", posts);
            return "full";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/grafsvet")
    public String grafsvet(Model model) {
        if (root) {
            String jsonData = grafick.generate("svet");
            model.addAttribute("jsonData", jsonData);
            return "grafik"; // Предположим, это имя вашего шаблона Thymeleaf
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/grafvlashnost")
    public String grafvlashnost(Model model) {
        if (root) {
            String jsonData = grafick.generate("vlashnost");
            model.addAttribute("jsonData", jsonData);
            return "grafik";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/graftemp")
    public String graftemp(Model model) {
        if (root) {
            String jsonData = grafick.generate("temp");
            model.addAttribute("jsonData", jsonData);
            return "grafik";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/dopsveton")
    public String dopsveton(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "1", "2");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/dopvlashnoston")
    public String dopvlashnoston(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "2", "2");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/dopvinton")
    public String dopvinton(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "3", "2");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/doptempon")
    public String doptempon(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "4", "2");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/dopsvetoff")
    public String dopsvetoff(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "1", "1");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/dopvlashnostoff")
    public String dopvlashnostoff(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "2", "1");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/dopvintoff")
    public String dopvintoff(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "3", "1");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
    @GetMapping("/doptempoff")
    public String doptempoff(Model model) {
        if (root) {
            Esp32Client esp = new Esp32Client();
            esp.startReleOnOff(myComp.getIpesp(), myComp.getMyToken(), "4", "1");
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/startsmart")
    public String strstartsmart(Model model) {
        if (root) {
            return "smart";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/startstatica")
    public String startstatica(Model model) {
        if (root) {
            return "statica";
        } else {
            return "autorisation";
        }
    }

    @GetMapping("/tgstart")
    public String tgstart(Model model) {
        if (root) {
            Thread thread = new Thread(new StartBot());
            thread.start();
            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }

    @PostMapping("/dannyestartsmart")
    public String startsmart(@RequestParam String temp, @RequestParam String vlashnost, @RequestParam String svet, @RequestParam String timesvet, @RequestParam String timetemp, @RequestParam String timevlashnost, Model model) {
        if (root) {
            Thread smart = new Thread(new SmartUpravESP(Double.parseDouble(temp), Double.parseDouble(vlashnost), Integer.parseInt(svet), myComp.getMyToken(), myComp.getIpesp(), timetemp, timesvet, timevlashnost));
            smart.start();

            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }

    @PostMapping("/dannyestatistica")
    public String dannyestatistica(@RequestParam String time, Model model) {
        if (root) {
            Thread statica = new Thread(new SmartStatic(Integer.parseInt(time), myComp.getIpesp(), myComp.getMyToken()));
            statica.start();

            return "redirect:/glav";
        } else {
            return "autorisation";
        }
    }
}
