package com.example.MeteoStarSpring.dop;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public class Esp32Client {

    private String svet;
    private String vlashnost;
    private String temp;

    public String getSvet() {
        return svet;
    }

    public String getVlashnost() {
        return vlashnost;
    }

    public String getTemp() {
        return temp;
    }

    public void Esp32GetJson(String ip, String token) {
        // Пример: http://192.168.1.100/admin/token/reiojfjoiwr38923e0u58turwkjowHFI733jwf023/
        String urlString = "http://" + ip + token;

        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");

            int responseCode = connection.getResponseCode();
            System.out.println("Response Code: " + responseCode);

            if (responseCode == HttpURLConnection.HTTP_OK) {
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String inputLine;
                StringBuilder response = new StringBuilder();

                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();

                String jsonResponse = response.toString();
                System.out.println("JSON Response: " + jsonResponse);

                JSONObject jsonObject = new JSONObject(jsonResponse);
                this.svet = jsonObject.optString("light", "1");
                this.temp = jsonObject.optString("temperature", "183");
                this.vlashnost = jsonObject.optString("humidity", "6");

                System.out.println("GET request worked");
            } else {
                System.out.println("GET request NOT worked");
            }
        } catch (Exception e) {
            System.out.println("Error get json - " + e);
        }
    }




    public void startReleOnOff(String ip, String token, String num_rele, String work) { // 1-off 2-on
        String urlString = "http://" + ip + token + "rele" + num_rele + "?work=" + work;

        try {
            URL url = new URL(urlString);

            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");

            int responseCode = connection.getResponseCode();
            System.out.println("Response Code: " + responseCode);

            if (responseCode == HttpURLConnection.HTTP_OK) {
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String inputLine;
                StringBuilder response = new StringBuilder();

                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();

                if (Integer.parseInt(work) == 1) {
                    System.out.println("Rele " + num_rele + " turned OFF");
                } else {
                    System.out.println("Rele " + num_rele + " turned ON");
                }
            }
        } catch (Exception e) {
            System.out.println("Error smart rele - " + e);
        }
    }
}


