package com.example.MeteoStarSpring.dop;

import com.example.MeteoStarSpring.components.MyComponent;
import com.example.MeteoStarSpring.dop.smart.Ssvet;
import com.example.MeteoStarSpring.dop.smart.Stemp;
import com.example.MeteoStarSpring.dop.smart.Svlashnost;
import org.springframework.beans.factory.annotation.Autowired;

public class SmartUpravESP implements Runnable {

    @Autowired
    MyComponent myComp;

    private double norms_temp, norms_vlashnost;
    private int norms_svet;
    private String token, ip, smart_time_temp, smart_time_svet, smart_time_vlashnost;

    public SmartUpravESP(double norms_temp, double norms_vlashnost, int norms_svet, String token, String ip, String smart_time_temp, String smart_time_svet, String smart_time_vlashnost) {
        this.norms_temp = norms_temp;
        this.norms_vlashnost = norms_vlashnost;
        this.norms_svet = norms_svet;
        this.token = token;
        this.ip = ip;
        this.smart_time_temp = smart_time_temp;
        this.smart_time_svet = smart_time_svet;
        this.smart_time_vlashnost = smart_time_vlashnost;
    }

    @Override
    public void run() {
        for (;;) {
            System.out.println("Проверяем теплицу..");

            norm();

            try {
                Thread.sleep(30000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void norm() {
        Esp32Client esp = new Esp32Client();
        esp.Esp32GetJson(ip, token);

        Thread stemp = new Thread(new Stemp(norms_temp, String.valueOf(esp.getTemp()), smart_time_temp, ip, token, "4")); // num_rele доделать
        stemp.start();

        Thread ssvet = new Thread(new Ssvet(norms_svet, String.valueOf(esp.getSvet()), smart_time_svet, ip, token, "1"));
        ssvet.start();

        Thread svlashnost = new Thread(new Svlashnost(norms_vlashnost, String.valueOf(esp.getVlashnost()), smart_time_vlashnost, ip, token, "2"));
        svlashnost.start();

    }
}
