package com.example.MeteoStarSpring.telegram;


import com.example.MeteoStarSpring.components.DateTime;
import com.example.MeteoStarSpring.dop.Esp32Client;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

import java.util.List;

public class Terminator extends TelegramLongPollingBot {
    private static NastroiBot nb = new NastroiBot();
    private static String botUsername = nb.getBotUsername();
    private static String botToken = nb.getBotToken();
    private static String allowedUserId = nb.getAllowedUserId();
    private static String ip = nb.getIp();
    private static String adminToken = nb.getAdminToken();

    public Terminator() {
        super(botToken);
    }

    @Override
    public void onUpdateReceived(Update update) {
        if (update.hasMessage() && update.getMessage().hasText()) {
            long userId = update.getMessage().getFrom().getId();
            if (userId == Long.parseLong(allowedUserId)) {
                String messageText = update.getMessage().getText();
                SendMessage message = new SendMessage();
                message.setChatId(String.valueOf(userId));
                Esp32Client client = new Esp32Client();
                switch (messageText) {
                    case "Свет вкл✅":
                        client.startReleOnOff(ip, adminToken, "1", "2");
                        message.setText("\uD83D\uDCCDСвет включен");
                        System.out.println("Свет включен");
                        break;
                    case "Свет выкл⛔️":
                        client.startReleOnOff(ip, adminToken, "1", "1");
                        message.setText("\uD83D\uDCCDСвет выключен");
                        System.out.println("Свет выключен");
                        break;
                    case "Полив вкл✅":
                        client.startReleOnOff(ip, adminToken, "2", "2");
                        message.setText("\uD83D\uDCCDПолив включен");
                        System.out.println("Полив включен");
                        break;
                    case "Полив выкл⛔️":
                        client.startReleOnOff(ip, adminToken, "2", "1");
                        message.setText("\uD83D\uDCCDПолив выключен");
                        System.out.println("Полив выключен");
                        break;
                    case "Вентилятор вкл✅":
                        client.startReleOnOff(ip, adminToken, "3", "2");
                        message.setText("\uD83D\uDCCDОтопление включено");
                        System.out.println("Отопление включено");
                        break;
                    case "Вентилятор выкл⛔️":
                        client.startReleOnOff(ip, adminToken, "3", "1");
                        message.setText("\uD83D\uDCCDОтопление выключено");
                        System.out.println("Отопление выключено");
                        break;
                    case "Отопление вкл✅":
                        client.startReleOnOff(ip, adminToken, "4", "2");
                        message.setText("\uD83D\uDCCDОтопление включено");
                        System.out.println("Отопление включено");
                        break;
                    case "Отопление выкл⛔️":
                        client.startReleOnOff(ip, adminToken, "4", "1");
                        message.setText("\uD83D\uDCCDОтопление выключено");
                        System.out.println("Отопление выключено");
                        break;
                    case "Обновить данные\uD83D\uDCE9":
                        message.setText(otvet());
                        break;
                    default:
                        message.setText(otvet());
                        break;
                }

                try {
                    execute(message);
                    addUpdateButton(userId);
                } catch (TelegramApiException e) {
                    e.printStackTrace();
                }
            }
        } else if (update.hasCallbackQuery()) {
            long userId = update.getCallbackQuery().getFrom().getId();
            if (userId == Long.parseLong(allowedUserId)) {
                SendMessage message = new SendMessage();
                message.setChatId(String.valueOf(userId));
                message.setText(otvet());
                try {
                    execute(message);
                } catch (TelegramApiException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addUpdateButton(long chatId) {
        SendMessage message = new SendMessage();
        message.setChatId(String.valueOf(chatId));
        message.setText("\uD83D\uDCDDВыберите действие:");

        ReplyKeyboardMarkup replyKeyboardMarkup = new ReplyKeyboardMarkup();
        message.setReplyMarkup(replyKeyboardMarkup);

        KeyboardRow keyboardRow1 = new KeyboardRow();
        keyboardRow1.add("Полив вкл✅");
        keyboardRow1.add("Полив выкл⛔️");

        KeyboardRow keyboardRow2 = new KeyboardRow();
        keyboardRow2.add("Свет вкл✅");
        keyboardRow2.add("Свет выкл⛔️");

        KeyboardRow keyboardRow3 = new KeyboardRow();
        keyboardRow3.add("Отопление вкл✅");
        keyboardRow3.add("Отопление выкл⛔️");

        KeyboardRow keyboardRow4 = new KeyboardRow();
        keyboardRow4.add("Вентилятор вкл✅");
        keyboardRow4.add("Вентилятор выкл⛔️");

        KeyboardRow keyboardRow5 = new KeyboardRow();
        keyboardRow5.add("Обновить данные\uD83D\uDCE9");

        replyKeyboardMarkup.setKeyboard(List.of(keyboardRow1, keyboardRow2, keyboardRow3, keyboardRow4, keyboardRow5));

        try {
            execute(message);
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    private String otvet() {
        DateTime dateTime = new DateTime();

        Esp32Client esp = new Esp32Client();
        esp.Esp32GetJson(ip, adminToken);

        return "Обновленные данные на время\uD83C\uDF34 -> " +
                "\n⌛️ Время: " + dateTime.dt() +
                "\n \uD83C\uDF21️ Температура: " + esp.getTemp() +
                "\n \uD83D\uDCA1 Свет: " + esp.getSvet() +
                "\n \uD83D\uDCA6 Влажность: " + esp.getVlashnost();
    }

    @Override
    public String getBotUsername() {
        return botUsername;
    }

    @Override
    public String getBotToken() {
        return botToken;
    }
}


