package mod;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class AvtoZagruzka {


    public void setStartup(boolean startup, String jarPath) {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            if (new File(System.getProperty("user.home") + "/Library/LaunchAgents/ru.sp.workjava.plist").exists()) {
                new File(System.getProperty("user.home") + "/Library/LaunchAgents/ru.sp.workjava.plist").delete();
            }
            String plist_text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            plist_text += "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n";
            plist_text += "<plist version=\"1.0\">\n";
            plist_text += "	<dict>\n";
            plist_text += "		<key>Label</key>\n";
            plist_text += "		<string>ru.sp.workjava</string>\n";
            plist_text += "		<key>ProgramArguments</key>\n";
            plist_text += "		<array>\n";
            plist_text += "			<string>/usr/bin/java</string>\n";
            plist_text += "			<string>-jar</string>\n";
            plist_text += "			<string>" + jarPath + "</string>\n";
            plist_text += "		</array>\n";
            plist_text += "		<key>RunAtLoad</key>\n";
            plist_text += "		<true/>\n";
            plist_text += "	</dict>\n";
            plist_text += "</plist>";

            File plist = new File(System.getProperty("user.home") + "/Library/LaunchAgents/ru.sp.workjava.plist");
            if (!plist.exists()) {
                try {
                    plist.createNewFile();
                } catch (IOException e) {
                    System.out.println("Ошибка при создании загрузочного файла plist - " + e);
                }
            }

            if (startup) {
                FileWriter writeFile = null;
                try {
                    writeFile = new FileWriter(plist);
                    writeFile.write(plist_text);
                } catch (IOException e) {
                    System.out.println("Ошибка при автозапуске (+1) - " + e);
                } finally {
                    if (writeFile != null) {
                        try {
                            writeFile.close();
                        } catch (IOException e) {
                            System.out.println("Ошибка при автозапуске (+2) - " + e);
                        }
                    }
                }
            } else {
                if (plist.exists()) {
                    plist.delete();
                }
            }
        } else {
            String s;
            if (startup) {
                s = "cmd /C reg add HKCU\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /v " +
                        "workjava /t REG_SZ /d \"javaw -jar \\\"" + jarPath + "\\\"\" /f";
            } else {
                s = "cmd /C reg delete HKCU\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run " +
                        "/v workjava /f\r\n";
            }
            try {
                Runtime.getRuntime().exec(s);
            } catch (IOException e) {
                System.out.println("Ошибка при автозапуске (+3) - " + e);
            }
        }
    }
}
