package work;

import javax.sound.sampled.*;
import java.io.ByteArrayOutputStream;
import java.io.File;

public class Audio {

    private int second;
    private String put;

    public Audio(int second, String put) {
        this.second = second;
        this.put = put;
    }

    public boolean work() {
        try {
            AudioFormat format = new AudioFormat(44100, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);

            if (!AudioSystem.isLineSupported(info)) {
                return false;
            }

            TargetDataLine microphone = (TargetDataLine) AudioSystem.getLine(info);
            microphone.open(format);

            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            microphone.start();

            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < second * 1000) {
                int bytesRead = microphone.read(buffer, 0, buffer.length);
                out.write(buffer, 0, bytesRead);
            }

            microphone.stop();
            microphone.close();

            byte[] audioData = out.toByteArray();
            AudioInputStream stream = new AudioInputStream(
                    new java.io.ByteArrayInputStream(audioData),
                    format,
                    audioData.length / format.getFrameSize()
            );

            AudioSystem.write(stream, AudioFileFormat.Type.WAVE, new File(put));

            return true;

        }  catch (Exception e) {
            System.out.println("Error - " + e);
            return false;
        }
    }

}
