package work;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcessSbor {

    public List<String> getAllProcesses() {
        List<ProcessInfo> processes = collectProcesses();
        return formatProcessList(processes);
    }

    private List<ProcessInfo> collectProcesses() {
        if (isWindows()) {
            return collectWindowsProcesses();
        } else {
            return collectUnixProcesses();
        }
    }

    private List<ProcessInfo> collectWindowsProcesses() {
        List<ProcessInfo> processes = new ArrayList<>();
        try {
            Process process = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\" + "tasklist.exe /V");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                // Пропускаем заголовки
                reader.readLine();
                reader.readLine();

                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().isEmpty()) {
                        String[] parts = line.split("\\s+", 8);
                        if (parts.length >= 8) {
                            String name = parts[0];
                            String pid = parts[1];
                            String windowTitle = parts[7]; // Заголовок окна помогает идентифицировать приложения

                            // Фильтруем только пользовательские приложения
                            if (!name.equalsIgnoreCase("System") &&
                                    !name.equalsIgnoreCase("Idle") &&
                                    !name.endsWith(".dll") &&
                                    !name.startsWith("svchost")) {
                                processes.add(new ProcessInfo(name, pid, windowTitle));
                            }
                        }
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("Error collecting Windows processes: " + e.getMessage());
        }
        return processes;
    }

    private List<ProcessInfo> collectMacProcesses() {
        List<ProcessInfo> processes = new ArrayList<>();
        try {
            Process process = Runtime.getRuntime().exec("ps -A -c -o pid,comm");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                reader.readLine();

                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().isEmpty()) {
                        String[] parts = line.trim().split("\\s+", 2);
                        if (parts.length >= 2) {
                            String pid = parts[0];
                            String name = parts[1];

                            // Фильтруем системные процессы
                            if (!name.startsWith("com.apple") &&
                                    !name.equals("kernel_task") &&
                                    !name.startsWith("WindowServer")) {
                                processes.add(new ProcessInfo(name, pid, ""));
                            }
                        }
                    }
                }
            }
            Process process1 = Runtime.getRuntime().exec("ps aux");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process1.getInputStream()))) {
                String line;
                // Пропускаем заголовок
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().isEmpty()) {
                        String[] parts = line.trim().split("\\s+");
                        if (parts.length >= 11) {
                            String pid = parts[1].trim();
                            String name = parts[10].trim();
                            String memory = parts[5].trim() + " KB";
                            processes.add(new ProcessInfo(name, pid, memory));
                        }
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("Error collecting Mac processes: " + e.getMessage());
        }
        return processes;
    }

    private List<ProcessInfo> collectUnixProcesses() {
        List<ProcessInfo> processes = new ArrayList<>();
        try {
            Process process = Runtime.getRuntime().exec("ps aux");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()))) {
                String line;
                // Пропускаем заголовок
                reader.readLine();
                while ((line = reader.readLine()) != null) {
                    if (!line.trim().isEmpty()) {
                        String[] parts = line.trim().split("\\s+");
                        if (parts.length >= 11) {
                            String pid = parts[1].trim();
                            String name = parts[10].trim();
                            String memory = parts[5].trim() + " KB";
                            processes.add(new ProcessInfo(name, pid, memory));
                        }
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("Error collecting Unix processes: " + e.getMessage());
        }
        return processes;
    }


    private List<String> formatProcessList(List<ProcessInfo> processes) {
        List<String> result = new ArrayList<>();
        StringBuilder sb = new StringBuilder();

        sb.append("Запущенные приложения:\n");
        sb.append("PID\tИмя приложения\n");
        sb.append("----------------\n");

        for (ProcessInfo process : processes) {
            String line = process.getPid() + "\t" + process.getName() + "\n";

            if (sb.length() + line.length() > 4000) {
                result.add(sb.toString());
                sb = new StringBuilder();
                sb.append("Запущенные приложения (продолжение):\n");
                sb.append("PID\tИмя приложения\n");
                sb.append("----------------\n");
            }

            sb.append(line);
        }

        if (sb.length() > 0) {
            result.add(sb.toString());
        }

        return result;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static class ProcessInfo {
        private final String name;
        private final String pid;
        private final String additionalInfo;

        public ProcessInfo(String name, String pid, String additionalInfo) {
            this.name = name;
            this.pid = pid;
            this.additionalInfo = additionalInfo;
        }

        public String getName() {
            // Для Windows используем заголовок окна, если он есть
            if (!additionalInfo.isEmpty() && !additionalInfo.equals("N/A")) {
                return name + " (" + additionalInfo + ")";
            }
            return name;
        }

        public String getPid() { return pid; }
    }

}