package work;

import org.jcodec.api.SequenceEncoder;
import org.jcodec.scale.AWTUtil;
import org.jcodec.common.model.Picture;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

public class ZapisMon {

    private int second;
    private String put;

    public ZapisMon(int second, String put) {
        this.second = second;
        this.put = put;
    }

    public void work() {
        System.setProperty("apple.awt.UIElement", "true");
        final int FPS = 3;

        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int width = screenSize.width;
            int height = screenSize.height;
            SequenceEncoder encoder = SequenceEncoder.createSequenceEncoder(new File(put), FPS);
            Robot robot = new Robot();
            long startTime = System.currentTimeMillis();
            long endTime = startTime + (second * 1000);

            while (System.currentTimeMillis() < endTime) {
                BufferedImage screenshot = robot.createScreenCapture(new Rectangle(width, height));
                Picture picture = AWTUtil.fromBufferedImageRGB(screenshot);
                encoder.encodeNativeFrame(picture);
                long timeToWait = (1000 / FPS) -
                        (System.currentTimeMillis() - startTime) % (1000 / FPS);
                if (timeToWait > 0) {
                    Thread.sleep(timeToWait);
                }
            }
            encoder.finish();

        } catch (Exception e) {
            System.err.println("Error - " + e);
        }
    }

}