/*
 * Decompiled with CFR 0.152.
 */
package com.company.chat.client;

import com.company.chat.client.Tres;
import com.company.chat.network.TCPConnection;
import com.company.chat.network.TCPConnectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ClientWindow
extends JFrame
implements ActionListener,
TCPConnectionListener {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 400;
    private final JTextArea log = new JTextArea();
    private final JTextField fieldNickName = new JTextField("\u8f93\u5165\u4f60\u7684\u540d\u5b57");
    private final JTextField fieldInput = new JTextField();
    private TCPConnection connection;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Tres().start();
            }
        });
    }

    public ClientWindow(String ip, int port) {
        this.setDefaultCloseOperation(3);
        this.setTitle("chat");
        this.setSize(300, 400);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.log.setEditable(false);
        this.log.setLineWrap(true);
        this.add((Component)this.log, "Center");
        this.fieldInput.addActionListener(this);
        this.add((Component)this.fieldInput, "South");
        this.add((Component)this.fieldNickName, "North");
        this.log.setBackground(Color.GRAY);
        this.fieldNickName.setBackground(Color.GRAY);
        this.fieldInput.setBackground(Color.GRAY);
        super.setBackground(Color.GRAY);
        this.getRootPane().setBackground(Color.GRAY);
        this.getLayeredPane().setBackground(Color.GRAY);
        this.getContentPane().setBackground(Color.GRAY);
        this.setBackground(Color.CYAN);
        JScrollPane talkPane = new JScrollPane(this.log, 22, 30);
        talkPane.setVerticalScrollBarPolicy(21);
        talkPane.setBackground(Color.GRAY);
        this.add(talkPane);
        this.setVisible(false);
        try {
            this.connection = new TCPConnection(this, ip, port);
        }
        catch (IOException e) {
            this.printMsg("Connection exception: " + e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = this.fieldInput.getText();
        if (msg.equals("")) {
            return;
        }
        this.fieldInput.setText(null);
        System.out.println(this.connection);
        this.connection.sendString(this.fieldNickName.getText() + ": " + msg);
    }

    @Override
    public void onConnectionReady(TCPConnection tcpConnection) {
        this.printMsg("Connection ready...");
    }

    @Override
    public void onReceiveString(TCPConnection tcpConnection, String value) {
        this.printMsg(value);
    }

    @Override
    public void onDisconnect(TCPConnection tcpConnection) {
        this.printMsg("Connection close");
    }

    @Override
    public void onException(TCPConnection tcpConnection, Exception e) {
        this.printMsg("Connection exception: " + e);
    }

    private synchronized void printMsg(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClientWindow.this.log.append(msg + "\n");
                ClientWindow.this.log.setCaretPosition(ClientWindow.this.log.getDocument().getLength());
            }
        });
    }
}

