/*
 * Decompiled with CFR 0.152.
 */
package com.company.chat.server;

import com.company.chat.network.TCPConnection;
import com.company.chat.network.TCPConnectionListener;
import com.company.chat.server.Poge;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ChatServer
extends JFrame
implements TCPConnectionListener {
    private final ArrayList<TCPConnection> connections = new ArrayList();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Poge().start();
            }
        });
    }

    public ChatServer(int port) {
        System.out.println("Server running...");
        try {
            ServerSocket serverSocket = new ServerSocket(port);
            try {
                while (true) {
                    try {
                        while (true) {
                            new TCPConnection(this, serverSocket.accept());
                        }
                    }
                    catch (IOException e) {
                        System.out.println("TCPConnection exception " + e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void onConnectionReady(TCPConnection tcpConnection) {
        this.connections.add(tcpConnection);
        this.sendAllConnections("Client connected(+1): " + tcpConnection);
    }

    @Override
    public synchronized void onReceiveString(TCPConnection tcpConnection, String value) {
        this.sendAllConnections(value);
    }

    @Override
    public synchronized void onDisconnect(TCPConnection tcpConnection) {
        this.connections.remove(tcpConnection);
        this.sendAllConnections("Client disconnected: " + tcpConnection);
    }

    @Override
    public synchronized void onException(TCPConnection tcpConnection, Exception e) {
        System.out.println("TCPConnection exception " + e);
    }

    private void sendAllConnections(String value) {
        System.out.println(value);
        int cnt = this.connections.size();
        for (int i = 0; i < cnt; ++i) {
            this.connections.get(i).sendString(value);
        }
    }
}

