/*
 * Decompiled with CFR 0.152.
 */
package com.company.chat.network;

import com.company.chat.network.TCPConnectionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;

public class TCPConnection {
    private final Socket socket;
    private final Thread rxThread;
    private final TCPConnectionListener eventListener;
    private final BufferedReader in;
    private final BufferedWriter out;

    public TCPConnection(TCPConnectionListener eventListener, String ipAddres, int port) throws IOException {
        this(eventListener, new Socket(ipAddres, port));
    }

    public TCPConnection(final TCPConnectionListener eventListener, Socket socket) throws IOException {
        this.eventListener = eventListener;
        this.socket = socket;
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charset.forName("UTF-8")));
        this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8")));
        this.rxThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    eventListener.onConnectionReady(TCPConnection.this);
                    while (!TCPConnection.this.rxThread.isInterrupted()) {
                        eventListener.onReceiveString(TCPConnection.this, TCPConnection.this.in.readLine());
                    }
                }
                catch (IOException e) {
                    eventListener.onException(TCPConnection.this, e);
                }
                finally {
                    eventListener.onDisconnect(TCPConnection.this);
                }
            }
        });
        this.rxThread.start();
    }

    public synchronized void sendString(String value) {
        try {
            this.out.write(value + "\r\n");
            this.out.flush();
        }
        catch (IOException e) {
            this.eventListener.onException(this, e);
            this.disconnect();
        }
    }

    public synchronized void disconnect() {
        this.rxThread.interrupt();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.eventListener.onException(this, e);
        }
    }

    public String toString() {
        return "TCPConnection: " + this.socket.getInetAddress() + ": " + this.socket.getPort();
    }
}

