package com.company.chat.client;

import com.company.chat.network.TCPConnection;
import com.company.chat.network.TCPConnectionListener;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class ClientWindow extends JFrame implements ActionListener, TCPConnectionListener {


    private static final int WIDTH = 300;
    private static final int HEIGHT = 400;


//---------------------------------------------------------------------------------------------------------------------

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                // new ClientWindow(); // было

               new Tres().start();
            }
        });
    }
//---------------------------------------------------------------------------------------------------------------------

    private final JTextArea log = new JTextArea();
    private final JTextField fieldNickName = new JTextField("输入你的名字");
    private final JTextField fieldInput = new JTextField();

    private TCPConnection connection;




//---------------------------------------------------------------------------------------------------------------------

    public ClientWindow(String ip, int port) {
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        setTitle("chat");
        setSize(WIDTH, HEIGHT);


        setLocationRelativeTo(null);
        setAlwaysOnTop(true);
        log.setEditable(false);
        log.setLineWrap(true);
        add(log, BorderLayout.CENTER); // во
        fieldInput.addActionListener(this);
        add(fieldInput, BorderLayout.SOUTH);
        add(fieldNickName, BorderLayout.NORTH);

        // цвет
        log.setBackground(Color.GRAY);
        fieldNickName.setBackground(Color.GRAY);
        fieldInput.setBackground(Color.GRAY);
        super.setBackground(Color.GRAY);
        getRootPane().setBackground(Color.GRAY);
        getLayeredPane().setBackground(Color.GRAY);
        getContentPane().setBackground(Color.GRAY);
        setBackground(Color.CYAN);

        JScrollPane talkPane = new JScrollPane(log, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

        // КОМИТНИ ЭТУ СТРОЧКУ, ЕСЛИ НУЖНО БУДЕТ ВКЛЮЧИТЬ ПОЛОСУ ПРОКРУТКИ СБОКУ
        talkPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);



        talkPane.setBackground(Color.GRAY);
        add(talkPane);


        setVisible(false);  // true

        try {
            connection = new TCPConnection(this, ip, port);

        } catch (IOException e) {
            printMsg("Connection exception: " + e);
        }
    }



//---------------------------------------------------------------------------------------------------------------------

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = fieldInput.getText();
        if (msg.equals("")) return;
        fieldInput.setText(null);
        System.out.println(connection);
        connection.sendString(fieldNickName.getText() + ": " + msg);
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public void onConnectionReady(TCPConnection tcpConnection) {
        printMsg("Connection ready...");
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public void onReceiveString(TCPConnection tcpConnection, String value) {
        printMsg(value);
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public void onDisconnect(TCPConnection tcpConnection) {
        printMsg("Connection close");
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public void onException(TCPConnection tcpConnection, Exception e) {
        printMsg("Connection exception: " + e);
    }

//---------------------------------------------------------------------------------------------------------------------

    private synchronized void printMsg(String msg) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                log.append(msg + "\n");
                log.setCaretPosition(log.getDocument().getLength());
            }
        });

    }
}



// спроси сколько нужно оплатить и реквизиты