package com.company.chat.server;

import com.company.chat.network.TCPConnection;
import com.company.chat.network.TCPConnectionListener;

import javax.swing.*;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;

public class ChatServer extends JFrame implements TCPConnectionListener {

//---------------------------------------------------------------------------------------------------------------------

    public static void main(String[] args) {

        //new ChatServer();

        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                new Poge().start();
            }
        });
    }

//---------------------------------------------------------------------------------------------------------------------

    private final ArrayList<TCPConnection> connections = new ArrayList<>();

//---------------------------------------------------------------------------------------------------------------------

    public ChatServer(int port) {
        System.out.println("Server running...");
        try (ServerSocket serverSocket = new ServerSocket(port)){ // порт на котором будет работать сервер сокет
            while (true) {                                             // он ни как не хависит от порта ClientWindow
                try {
                    new TCPConnection(this, serverSocket.accept());
                } catch (IOException e) {
                    System.out.println("TCPConnection exception " + e);
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public synchronized void onConnectionReady(TCPConnection tcpConnection) {
        connections.add(tcpConnection);
        sendAllConnections("Client connected(+1): " + tcpConnection);
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public synchronized void onReceiveString(TCPConnection tcpConnection, String value) {
        sendAllConnections(value);
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public synchronized void onDisconnect(TCPConnection tcpConnection) {
        connections.remove(tcpConnection);
        sendAllConnections("Client disconnected: " + tcpConnection);
    }

//---------------------------------------------------------------------------------------------------------------------

    @Override
    public synchronized void onException(TCPConnection tcpConnection, Exception e) {
        System.out.println("TCPConnection exception " + e);
    }

//---------------------------------------------------------------------------------------------------------------------

    private void sendAllConnections(String value) {
        System.out.println(value);
        final int cnt = connections.size();
        for (int i = 0; i < cnt; i++) {
            connections.get(i).sendString(value);
        }
    }

}

