package com.example.csbananasite.security;

import com.example.csbananasite.service.CustomUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class SecurityConfig {

    @Autowired
    private CustomUserDetailsService userDetailsService;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http
                .authorizeHttpRequests(auth -> auth
                        .requestMatchers("/admin/token/dkjjsdkjfhsdkcDKHnfcsiuyHWydhjdfhsouUyqe/**", "/admin/token/sjsflewjfoiYHIUEjfiwejfoOkjfcei8FDJIOWFncjs/**").hasAuthority("ROLE_ADMIN")

                        .requestMatchers("/skinsAvtomaty/card/bay/**", "/skinsNakleyki/card/bay/**", "/skinsNoshi/card/bay/**", "/skinsPertatki/card/bay/**", "/skinsPistolets/card/bay/**"
                                , "/skinsAvtomaty/crypto/bay/**", "/skinsNakleyki/crypto/bay/**", "/skinsNoshi/crypto/bay/**", "/skinsPertatki/crypto/bay/**", "/skinsPistolets/crypto/bay/**"
                                , "/checkcrypto", "/checkcard", "/checksms/**").authenticated()

                        .requestMatchers("/", "/autoisation", "/regisation", "/skins", "/posts", "/post/**", "/cheatCSs", "/cheatCS/**", "/traff/**", "/filter", "/sbrosfilters",
                                "/skinsAvtomaty/**", "/skinsNakleyki/**", "/skinsNoshi/**", "/skinsPertatki/**", "/skinsPistolets/**", "/promocode",
                                "/admin/token/dpgjJnroijPJFEAIjdhsdkcDKHnfcsiuyHWydhjdfhsfohOAwhfjR/regisation",
                                "/css/**", "/js/**", "/images/**").permitAll()
                        .anyRequest().authenticated()
                )
                .formLogin(form -> form
                        .loginPage("/autoisation")
                        .loginProcessingUrl("/autoisation")
                        .defaultSuccessUrl("/skins")
                        .failureUrl("/autoisation?error=true")
                        .permitAll()
                )
                .logout(logout -> logout
                        .logoutSuccessUrl("/autoisation")
                        .permitAll()
                )
                .csrf(csrf -> csrf.disable()) // Отключаем CSRF для упрощения
                .userDetailsService(userDetailsService); // Используем кастомный UserDetailsService

        return http.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return NoOpPasswordEncoder.getInstance();
    }
}
