package com.example.chiptuningweb.controller;

import com.example.chiptuningweb.model.FullDan;
import com.example.chiptuningweb.repo.FullDanRepo;
import jakarta.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import java.io.IOException;

@Controller
public class UserController {

    @Autowired
    FullDanRepo fullDanRepo;

    @GetMapping("/")
    public String home(HttpSession session, Model model) {
        String sity = (String) session.getAttribute("sity");
        model.addAttribute("sity", sity != null ? sity : "no");
        return "user/home";
    }

    @GetMapping("/vixlop")
    public String vixlop(HttpSession session, Model model) {
        String sity = (String) session.getAttribute("sity");
        model.addAttribute("sity", sity != null ? sity : "no");
        return "user/vixlop";
    }

    @GetMapping("/kraska")
    public String kraska(HttpSession session, Model model) {
        String sity = (String) session.getAttribute("sity");
        model.addAttribute("sity", sity != null ? sity : "no");
        return "user/kraska";
    }

    @GetMapping("/sity/{sity}/")
    public String homesity(@PathVariable(value = "sity") String sity, HttpSession session, Model model) {
        session.setAttribute("sity", sity);
        model.addAttribute("sity", sity);
        return "user/home";
    }

    @GetMapping("/sity/{sity}/vixlop")
    public String vixlopsity(@PathVariable(value = "sity") String sity, HttpSession session, Model model) {
        session.setAttribute("sity", sity);
        model.addAttribute("sity", sity);
        return "user/vixlop";
    }

    @GetMapping("/sity/{sity}/kraska")
    public String kraskasity(@PathVariable(value = "sity") String sity, HttpSession session, Model model) {
        session.setAttribute("sity", sity);
        model.addAttribute("sity", sity);
        return "user/kraska";
    }

    @PostMapping("/formdann")
    public String savePost(@RequestParam String fio, @RequestParam String phone,
                           @RequestParam String modelavto, @RequestParam String usluga,
                           HttpSession session, Model model) {
        try {
            String sity = (String) session.getAttribute("sity");
            if (sity == null) {
                sity = "no";
            }

            LocalDateTime current = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss");
            String date = current.format(formatter);
            FullDan fullDan = new FullDan(date, fio, phone, modelavto, usluga, sity);
            fullDanRepo.save(fullDan);

            return "redirect:/";
        } catch (Exception e) {
            System.out.println("Error - " + e);
            return "user/home";
        }
    }
}